#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""dnat model"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)


class ACDNATModel(object):
    """ACDNATModel"""

    @staticmethod
    def ac_model_format(dnat, floatingip):
        """ac_model_format"""
        try:
            dnat_info = {
                'floatingip-id': floatingip['id'],
                'tenant-id': floatingip['tenant_id'],
                'floating-ip-address': floatingip['floating_ip_address'],
                'floating-network-id': floatingip['floating_network_id'],
                'router-id': dnat['router_id'],
                'port-id': dnat['port_id'],
                'fixed-ip-address': dnat['fixed_ip_address'],
                'uuid': dnat['id'],
                'protocol': dnat['protocol'],
                'floating-ip-port': dnat['floating_ip_port'],
                'fixed-ip-port': dnat['fixed_ip_port'],
            }
            if floatingip.get('created_at'):
                dnat_info['created-at'] = floatingip['created_at']
            if floatingip.get('updated_at'):
                dnat_info['updated-at'] = floatingip['updated_at']
        except KeyError as value:
            LOG.error(_LE("[AC]Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError

        return dnat_info
