#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""ACL2BRModel class """

from oslo_log import log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)


class ACL2BRModel(object):
    """ACL2BRModel class """

    @staticmethod
    def ac_model_format(l2br_dicts):
        """Convert data to AC model"""
        l2br_dict = l2br_dicts

        try:
            l2br_dict_info = {
                'uuid': l2br_dict['id']
            }
            if l2br_dict.get('name') and \
                    (l2br_dict['name'].strip() != ''):
                l2br_dict_info['name'] = l2br_dict['name']
            if l2br_dict.get('tenant_id'):
                l2br_dict_info['tenant-id'] = l2br_dict['tenant_id']

            ACL2BRModel.get_l2br_device_info(l2br_dict, l2br_dict_info)
            ACL2BRModel.get_l2br_service_info(l2br_dict, l2br_dict_info)

        except KeyError as value:
            LOG.error(_LE("[AC] Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError
        return l2br_dict_info

    @staticmethod
    def get_l2br_device_info(l2br_dict, l2br_dict_info):
        """get_l2br_device_info"""
        l2br_dict_info['device-info'] = {}
        if l2br_dict.get('device_info'):
            external_l2brs_info = l2br_dict['device_info']
            if external_l2brs_info.get('device_id') \
                    and (external_l2brs_info['device_id'].strip() != ''):
                l2br_dict_info['device-info']['device-name'] = \
                    external_l2brs_info['device_id']
            if external_l2brs_info.get('device_mac') \
                    and (external_l2brs_info['device_mac'].strip() != ''):
                l2br_dict_info['device-info']['device-mac'] = \
                    external_l2brs_info['device_mac']
            if external_l2brs_info.get('device_ip') \
                    and (external_l2brs_info['device_ip'].strip() != ''):
                l2br_dict_info['device-info']['device-ip'] = \
                    external_l2brs_info['device_ip']
            if external_l2brs_info.get('interface_id'):
                l2br_dict_info['device-info']['interface-name'] = \
                    external_l2brs_info['interface_id']

    @staticmethod
    def get_l2br_service_info(l2br_dict, l2br_dict_info):
        """get_l2br_service_info"""
        l2br_dict_info['service-info'] = {}
        if l2br_dict.get('service_info'):
            external_l2brs_info = l2br_dict['service_info']
            if external_l2brs_info.get('vlan_id'):
                l2br_dict_info['service-info']['vlan-id'] = \
                    external_l2brs_info['vlan_id']
            if external_l2brs_info.get('vni') \
                    and (external_l2brs_info['vni'] != 0):
                l2br_dict_info['service-info']['vni'] = \
                    external_l2brs_info['vni']
            if external_l2brs_info.get('network_id') \
                    and (external_l2brs_info['network_id'].strip() != ''):
                l2br_dict_info['service-info']['network-id'] = \
                    external_l2brs_info['network_id']
