#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""policy rule model"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)


class ACPolicyRuleModel(object):
    """ACPolicyRuleModel"""

    @staticmethod
    def ac_model_format(policy_rule, actions):
        """Convert data to AC model"""
        try:
            policy_rule_to_ac = {
                'name': policy_rule['name'],
                'tenant-id': policy_rule['tenant_id']
            }

            if 'id' in policy_rule \
                    and policy_rule['id'] is not None:
                policy_rule_to_ac['uuid'] = policy_rule['id']

            if 'description' in policy_rule \
                    and policy_rule['description'] is not None:
                policy_rule_to_ac['descr'] = policy_rule['description']

            if 'shared' in policy_rule:
                if policy_rule['shared'] is not None:
                    policy_rule_to_ac['shared'] = policy_rule['shared']

            if 'policy_classifier_id' in policy_rule \
                    and policy_rule['policy_classifier_id'] is not None:
                policy_rule_to_ac['classifier-id'] = \
                    policy_rule['policy_classifier_id']

            if actions:
                policy_rule_to_ac["action"] = actions[0]

        except KeyError as value:
            LOG.error(_LE("[AC]Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError

        return policy_rule_to_ac
