#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""policy rule set model"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)


class ACPolicyRuleSetModel(object):
    """ACPolicyRuleSetModel"""

    @staticmethod
    def ac_model_format(policy_rule_set):
        """Convert data to AC model"""
        try:

            policy_rule_set_to_ac = {
                'name': policy_rule_set['name'],
                'tenant-id': policy_rule_set['tenant_id']
            }

            if 'id' in policy_rule_set \
                    and policy_rule_set['id'] is not None:
                policy_rule_set_to_ac['uuid'] = policy_rule_set['id']

            if 'shared' in policy_rule_set:
                if policy_rule_set['shared'] is not None:
                    policy_rule_set_to_ac['shared'] = policy_rule_set['shared']

            if 'description' in policy_rule_set \
                    and policy_rule_set['description'] is not None:
                policy_rule_set_to_ac['descr'] = policy_rule_set['description']

            if 'policy_rules' in policy_rule_set \
                    and policy_rule_set['policy_rules'] is not None:
                policy_rule_set_to_ac['policy-rule-id'] = \
                    policy_rule_set['policy_rules']

        except KeyError as value:
            LOG.error(_LE("[AC]Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError

        return policy_rule_set_to_ac
