#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""query neutron client"""

from __future__ import print_function
import os
import re
import argparse
from distutils.sysconfig import get_python_lib
from neutronclient.common import extension

class ACCommonCtrl(extension.NeutronClientExtension):
    """ACControlCommands class

    """
    resource = 'huawei_query'
    resource_plural = '%ss' % resource
    object_path = '/%s' % resource_plural
    resource_path = '/%s/%%s' % resource_plural
    versions = ['2.0']


class Validate(argparse.Action):
    """validate"""
    def check(self):
        """check"""
        pass

    def __call__(self, parser, args, values, option_string=None):
        if option_string == '--query-version':
            setattr(args, self.dest, values)
            lib_path = get_python_lib()
            version_path = lib_path + '/networking_huawei/version.txt'
            python_version = re.findall(r"python\d+\.?\d*", lib_path)
            if not os.path.exists(version_path):
                version_path = os.path.realpath(
                    os.path.join(
                        '/usr/local/lib/', python_version[0],
                        '/dist-packages/networking_huawei/version.txt'))
            with open(version_path) as ver_path:
                try:
                    version_info = ver_path.read()
                    print(version_info)
                except Exception:
                    print('there is no file decording version in the system.')
        return parser


class PerformQuery(extension.ClientExtensionCreate, ACCommonCtrl):
    """perform query"""
    shell_command = 'acctrl'

    def add_known_arguments(self, parser):
        """This method is used to define the arguments that this CLI"""
        # command expects. When a user hits "huawei-query
        # --help", information from these are displayed.
        parser.add_argument(
            '--query-version',
            nargs='?',
            action=Validate,
            help='show the version of the current agile controller plugin.')

        return parser

    def run(self, parsed_args):
        """start run"""
        pass
