#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""compare result plugin"""

from oslo_log import log as logging
from networking_huawei.drivers.ac.extensions.compare_result import \
    compare_result as compare_result
from networking_huawei.drivers.ac.db.compare_result import compare_results_db
from networking_huawei._i18n import _LI
from networking_huawei.drivers.ac.common import constants

LOG = logging.getLogger(__name__)


class HuaweiCompareResultPlugin(compare_result.CompareresultBase,
                                compare_results_db.CompareDbMixin):
    """Implementation of the Huawei AC compare_result Service Plugin."""
    supported_extension_aliases = ['compare_result']

    def __init__(self):
        LOG.info(_LI("[AC] Init huawei compare_result plugin."))
        super(HuaweiCompareResultPlugin, self).__init__()
        LOG.info(_LI("[AC] Initialization finished successfully "
                     "for huawei compare_result plugin."))

    def get_plugin_type(self):
        """get plugin type"""
        return "compare_result"

    def get_plugin_description(self):
        """get plugin description"""
        return 'Huawei compare_results service plugin'

    def get_compare_results(self, context, filters=None, fields=None,
                            sorts=None, limit=None, marker_obj=None,
                            page_reverse=False):
        """get compare results"""
        LOG.info(_LI("[AC] Begin to get compare results."))
        compare_results = super(HuaweiCompareResultPlugin, self).\
            get_db_compare_results_query(context, filters=filters,
                                         fields=fields, sorts=sorts,
                                         limit=limit, marker_obj=marker_obj,
                                         page_reverse=page_reverse)

        if len(compare_results) == 1 and compare_results[0].get('id') and \
                str(compare_results[0].get('id')).isdigit() and \
                int(str(compare_results[0].get('id'))) == \
                constants.SYNC_NO_DIFFERENCE:
            compare_results = []
        return compare_results
