# !/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
"""
| 功能：AC 配置插件
| 修改记录：2022-03-18 15:00 创建
"""
from networking_huawei.drivers.ac.common.neutron_compatible_util import ac_log
from networking_huawei.drivers.ac.db.config_check.ac_basic_config_db import AcBasicConfigDBMixin
from networking_huawei.drivers.ac.extensions.config_check.ac_config_ext import Ac_config_ext
from networking_huawei.drivers.ac.plugins.abstract_neutron_service_plugin import AbstractServicePlugin

LOG = ac_log.getLogger(__name__)


class AcConfigPlugin(AbstractServicePlugin):
    """AC 配置插件类"""

    def __init__(self):
        super(AcConfigPlugin, self).__init__(Ac_config_ext())
        # 数据库
        self.db = AcBasicConfigDBMixin()

    def create_core(self, request, body=None, **kwargs):
        """see AbstractServicePlugin.create_core"""
        LOG.info('[ACConfigCheck]create ac config start:%s,body=%s,kwargs=%s', request, body, kwargs)
        create_req = body.get(self.extension.get_alias(), {})
        req_files = create_req.get('file')
        context = request.context

        if req_files:  # 清空数据库配置
            filters = {'config_file': req_files}
            for elem in self.db.list(context, filters=filters):
                self.db.delete(context, elem.id)

        req_data = create_req.get('data')
        if len(req_data) == 1:  # 创建单条配置
            result = self.db.create(context, req_data[0]).show()
        else:  # 创建多条的ac配置
            result = {}
            for elem in req_data:
                ac_config = self.db.create(context, elem)
                result[ac_config.config_file] = ac_config.show()

        LOG.info('[ACConfigCheck]create success:%s', result)
        return {self.extension.get_alias(): result}

    def show_core(self, request, pk_id, **kwargs):
        """see AbstractServicePlugin.show_core"""
        LOG.info('[ACConfigCheck]show ac config start:%s,body=%s,kwargs=%s', request, pk_id, kwargs)
        result = {self.extension.get_alias(): self.db.get(request.context, pk_id).show()}
        LOG.info('[ACConfigCheck]show success:%s', result)
        return result

    def list_core(self, request, **kwargs):
        """see AbstractServicePlugin.list_core"""
        LOG.info('[ACConfigCheck]list ac config start:%s,kwargs=%s', request, kwargs)
        result = []
        for elem in self.db.list(request.context, **kwargs):
            result.append(elem.show())
        LOG.info('[ACConfigCheck]list success:%s', result)
        return {self.extension.get_alias(): result}

    def delete_core(self, request, pk_id, **kwargs):
        """see AbstractServicePlugin.delete_core"""
        LOG.info('[ACConfigCheck]delete ac config start:%s,id=%s,kwargs=%s', request, pk_id, kwargs)
        context = request.context
        if pk_id == 'all':
            for elem in self.db.list(context):
                self.db.delete(context, elem.id)
        else:
            self.db.delete(context, pk_id)
        LOG.info('[ACConfigCheck]delete success:%s', pk_id)
