#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""dnat plugin"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LI, _LE
from networking_huawei.drivers.ac.db.dnat.dnat import DNATDBMixin
from networking_huawei.drivers.ac.extensions.dnat import dnat as extension
from networking_huawei.drivers.ac.common import constants as ac_constants
from networking_huawei.drivers.ac.model.dnat_model import ACDNATModel
from networking_huawei.drivers.ac.sync.message_reliability_api \
    import ACReliabilityAPI
from networking_huawei.drivers.ac.common import neutron_compatible_util as ncu

LOG = logging.getLogger(__name__)


class DNATPlugin(extension.DnatBase, DNATDBMixin):
    """DNAT Plugin"""
    supported_extension_aliases = [extension.DNAT]

    def __init__(self):
        super(DNATPlugin, self).__init__()
        self.reliability_api = ACReliabilityAPI(ac_constants.NW_HW_DNAT)
        self.ops_version = ncu.get_ops_version()

    def get_plugin_name(self):
        """get plugin name"""
        return extension.DNAT

    def get_plugin_type(self):
        """get plugin type"""
        return extension.DNAT

    def get_plugin_description(self):
        """get plugin description"""
        return extension.DNAT

    def create_dnat(self, context, dnat):
        """create dnat"""
        LOG.info(_LI('[AC] Begin to create DNAT: %s'), dnat)
        dnat_db = super(DNATPlugin, self).create_dnat_db(context, dnat)
        floatingip = super(DNATPlugin, self).get_floatingip(
            context, dnat_db['floating_ip_id'])
        dnat_info = ACDNATModel.ac_model_format(dnat_db, floatingip)
        try:
            self.reliability_api.update_plugin_record(
                context, dnat_db['id'], dnat_info,
                ac_constants.NW_HW_CREATE_DNAT)
        except Exception as ex:
            LOG.error(_LE('[AC] Huawei AC create DNAT failed: %s'), ex)
            super(DNATPlugin, self).delete_dnat_db(context, dnat_db['id'])
            raise ex
        LOG.info(_LI('[AC] Huawei AC create DNAT successfully'))
        return dnat_db

    def delete_dnat(self, context, dnat_id):
        """delete dnat"""
        LOG.info(_LI('[AC] Begin to delete DNAT: %s'), dnat_id)
        self.reliability_api.update_plugin_record(
            context, dnat_id, {}, ac_constants.NW_HW_DELETE_DNAT)
        super(DNATPlugin, self).delete_dnat_db(context, dnat_id)
        LOG.info(_LI('[AC] Huawei AC delete DNAT successfully'))

    def get_dnat(self, context, dnat_id, fields=None):
        """get dnat"""
        return super(DNATPlugin, self).get_dnat_db(context, dnat_id, fields)

    def get_dnats(self, context, filters=None, fields=None):
        """get dnats"""
        return super(DNATPlugin, self).get_dnats_db(context, filters, fields)
