# !/usr/bin/env python
# -*- coding:utf-8 -*-
"""
| 功能：dry run 工具方法
| 版本：2022-07-16 15:20 创建
"""

from networking_huawei.drivers.ac.common import constants as ac_constants

try:
    from neutron.common.exceptions import NeutronException
except ImportError:
    from neutron_lib.exceptions import NeutronException


class OperationNotSupportedException(NeutronException):
    message = "Update %(data_type)s's description from '%(origin_desc)s' to '%(current_desc)s' is not supported."


def is_dry_run_data(data, data_type=None):
    """判断是否是 dry run 生成的数据

    :param data: dict,数据具体内容
    :param data_type: str,资源类型
    :return: bool
    """
    if data_type not in {ac_constants.NW_HW_PORTS, ac_constants.NW_HW_QOS_POLICY, ac_constants.NW_HW_TAP_SERVICE,
                         ac_constants.NW_HW_TAP_FLOW, ac_constants.NW_HW_EXROUTE}:
        return False
    if data is None:
        return False
    # ex-route改成它在description用__resource_preemption标识
    description = data.get('description')
    if description is None and hasattr(data, 'description'):
        description = getattr(data, 'description', None)
    return description is not None and description.find('__resource_preemption') != -1


def check_whether_dryrun_to_product(res_type, operation, original, current):
    """已转正的业务不允许更新成dry run态

    :param res_type: data_type
    :param operation: operation
    :param original: original
    :param current: current
    """
    if operation != ac_constants.OPER_UPDATE:
        return
    if res_type not in {ac_constants.NW_HW_PORTS, ac_constants.NW_HW_QOS_POLICY, ac_constants.NW_HW_TAP_SERVICE,
                        ac_constants.NW_HW_TAP_FLOW, ac_constants.NW_HW_EXROUTE}:
        return
    origin_desc = original.get('description') if original else None
    current_desc = current.get('description') if current else None
    origin_dryrun = True if origin_desc and origin_desc.find('__resource_preemption') != -1 else False
    current_dryrun = True if current_desc and current_desc.find('__resource_preemption') != -1 else False
    if not origin_dryrun and current_dryrun:
        raise OperationNotSupportedException(data_type=res_type, origin_desc=origin_desc, current_desc=current_desc)
