#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""ac gbp external driver"""


from neutron.common import log


from gbpservice.neutron.services.grouppolicy import \
    group_policy_driver_api as api

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei.drivers.ac.model.external_segment_model import \
    ACExternalSegmentModel
from networking_huawei.drivers.ac.model.external_policy_model import \
    ACExternalPolicyModel
from networking_huawei.drivers.ac.common import constants as ac_constants
from networking_huawei.drivers.ac.sync.message_reliability_api \
    import ACReliabilityAPI
from networking_huawei._i18n import _LE, _LI

LOG = logging.getLogger(__name__)


class HuaweiACGBPExternalDriver(api.PolicyDriver):
    """Huawei AC GBP External Driver"""

    @log.log
    def initialize(self):
        """initialize"""
        self.reliability_api = ACReliabilityAPI(ac_constants.NW_HW_GBP_EXTERNAL)

    @log.log
    def create_external_segment_postcommit(self, context):
        """create external segment postcommit"""
        LOG.info(_LI("[AC] Request AC to create external segment: %s"),
                 context.current)
        try:
            external_segment_info = \
                ACExternalSegmentModel.ac_model_format(context.current)

            self.__rest_request__(context, context.current['id'],
                                  external_segment_info,
                                  ac_constants.NW_HW_CREATE_EXTERNAL_SEGMENT)
        except Exception as ex:
            LOG.error(_LE("[AC] Create external segment %s failed: %s"),
                      context.current['id'], ex)
            raise

    @log.log
    def update_external_segment_postcommit(self, context):
        """update external segment postcommit"""
        LOG.info(_LI("[AC] Request AC to update external segment: %s"),
                 context.current)
        try:
            external_segment_info = \
                ACExternalSegmentModel.ac_model_format(context.current)

            self.__rest_request__(context, context.current['id'],
                                  external_segment_info,
                                  ac_constants.NW_HW_UPDATE_EXTERNAL_SEGMENT)
        except Exception as ex:
            LOG.error(_LE("[AC] Update external segment %s failed: %s"),
                      context.current['id'], ex)
            raise

    @log.log
    def delete_external_segment_precommit(self, context):
        """delete external segment precommit"""
        LOG.info(_LI("[AC] Request AC to delete external segment: %s"),
                 context.current)
        try:
            external_segment_info = \
                ACExternalSegmentModel.ac_model_format(context.current)

            self.__rest_request__(context, context.current['id'],
                                  external_segment_info,
                                  ac_constants.NW_HW_DELETE_EXTERNAL_SEGMENT)
        except Exception as ex:
            LOG.error(_LE("[AC] Delete external segment %s failed: %s"),
                      context.current['id'], ex)
            raise

    @log.log
    def create_external_policy_postcommit(self, context):
        """create external policy postcommit"""
        LOG.info(_LI("[AC] Request AC to create external policy: %s"),
                 context.current)
        try:
            external_policy_info = \
                ACExternalPolicyModel.ac_model_format(context.current)

            self.__rest_request__(context, context.current['id'],
                                  external_policy_info,
                                  ac_constants.NW_HW_CREATE_EXTERNAL_POLICY)
        except Exception as ex:
            LOG.error(_LE("[AC] Create external policy %s failed: %s"),
                      context.current['id'], ex)
            raise

    @log.log
    def update_external_policy_postcommit(self, context):
        """update external policy postcommit"""
        LOG.info(_LI("[AC] Request AC to update external policy: %s"),
                 context.current)
        try:
            external_policy_info = \
                ACExternalPolicyModel.ac_model_format(context.current)

            self.__rest_request__(context, context.current['id'],
                                  external_policy_info,
                                  ac_constants.NW_HW_UPDATE_EXTERNAL_POLICY)
        except Exception as ex:
            LOG.error(_LE("[AC] Update external policy %s failed: %s"),
                      context.current['id'], ex)
            raise

    @log.log
    def delete_external_policy_precommit(self, context):
        """delete external policy precommit"""
        LOG.info(_LI("[AC] Request AC to update external policy: %s"),
                 context.current)
        try:
            external_policy_info = \
                ACExternalPolicyModel.ac_model_format(context.current)

            self.__rest_request__(context, context.current['id'],
                                  external_policy_info,
                                  ac_constants.NW_HW_DELETE_EXTERNAL_POLICY)
        except Exception as ex:
            LOG.error(_LE("[AC] Delete external policy %s failed: %s"),
                      context.current['id'], ex)
            raise

    def __rest_request__(self, context, res_id, entry_info, operation):
        self.reliability_api.update_plugin_record(context,
                                                  res_id,
                                                  entry_info,
                                                  operation)
