#!/bin/bash

#cfg_file uninstall

#back up the config file with the time this script running.
backuptime=`date +%y%m%d%T`
backupname="/etc/neutron/huawei_driver_config.ini.bak"$backuptime
cp -p /etc/neutron/huawei_driver_config.ini $backupname
rm /etc/neutron/huawei_driver_config.ini
cp /root/networking-huawei/tools/huawei_driver_config_ideploy_bak.ini /etc/neutron/huawei_driver_config.ini
echo "change huawei_driver_config.ini to backup file."

#cps_uninstall

echo "cps_uninstall  begin to uninstall..."
sleep 1
#service_plugins
echo "cps_uninstall  1. uninstall service_plugins..."
PLUGIN_PATH=networking_huawei.drivers.ac.plugins
L3_PLUGINS=$PLUGIN_PATH.l3.ac_l3_router_plugin.HuaweiACL3RouterPlugin
FWAAS_PLUGINS=$PLUGIN_PATH.fwaas.fwaas_plugin.HuaweiACFwaasPlugin
VPNAAS_PLUGINS=$PLUGIN_PATH.vpnaas.vpnaas_plugin.HuaweiIPsecVPNPlugin
SERVICE_PLUGINS=qos_extension,huawei_ac_l2br,huawei_ac_ext,$L3_PLUGINS,$FWAAS_PLUGINS,$VPNAAS_PLUGINS

exists_service_plugins=`sed '/^service_plugins =/!d;s/.*=//' /etc/neutron/neutron.conf`
old_sp_drivers=${exists_service_plugins// /}

if [[ $exists_service_plugins == *$L3_PLUGINS* ]]
then
	old_sp_drivers=`echo $old_sp_drivers | sed 's/networking_huawei.drivers.ac.plugins.l3.ac_l3_router_plugin.HuaweiACL3RouterPlugin,/router,/g' | sed 's/^,//' | sed 's/,$//'`
fi

if [[ $exists_service_plugins == *$FWAAS_PLUGINS* ]]
then
	old_sp_drivers=`echo $old_sp_drivers | sed 's/networking_huawei.drivers.ac.plugins.fwaas.fwaas_plugin.HuaweiACFwaasPlugin,//g' | sed 's/^,//' | sed 's/,$//'`
fi 

if [[ $exists_service_plugins == *$VPNAAS_PLUGINS* ]]
then
	old_sp_drivers=`echo $old_sp_drivers | sed 's/networking_huawei.drivers.ac.plugins.vpnaas.vpnaas_plugin.HuaweiIPsecVPNPlugin//g' | sed 's/^,//' | sed 's/,$//'`
fi 

if [[ $exists_service_plugins == *huawei_ac_l2br* ]]
then
	old_sp_drivers=`echo $old_sp_drivers | sed 's/huawei_ac_l2br,//g' | sed 's/^,//' | sed 's/,$//'`
fi

if [[ $exists_service_plugins == *huawei_ac_ext* ]]
then
	old_sp_drivers=`echo $old_sp_drivers | sed 's/huawei_ac_ext,//g' | sed 's/^,//' | sed 's/,$//'`
fi

if [[ $exists_service_plugins == *huawei_ac_portforwarding* ]]
then
	old_sp_drivers=`echo $old_sp_drivers | sed 's/huawei_ac_portforwarding,//g' | sed 's/^,//' | sed 's/,$//'`
fi

cps template-params-update --service neutron neutron-server --parameter service_plugins=${old_sp_drivers// /}
cps commit

#mechanism_drivers
echo "cps_uninstall  2. uninstall mechanism_drivers..."
sleep 3
exists_mechanism_drivers=`sed '/^mechanism_drivers =/!d;s/.*=//' /etc/neutron/plugins/ml2/ml2_conf.ini`
old_mech_drivers=${exists_mechanism_drivers// /}

if [[ $exists_mechanism_drivers == *huawei_ac_ml2,* ]]
then
	old_mech_drivers=`echo $old_mech_drivers | sed 's/huawei_ac_ml2//g' | sed 's/^,//' | sed 's/,$//'`
	cps template-params-update --service neutron neutron-server --parameter mechanism_drivers=$old_mech_drivers
	cps commit
fi

current_extension_drivers=`sed '/^extension_drivers =/!d;s/.*=//' /etc/neutron/plugins/ml2/ml2_conf.ini`
current_extension_drivers=`echo $current_extension_drivers | sed 's/huawei_ac_binding,//g' | sed 's/,huawei_ac_binding//g' | sed 's/huawei_ac_binding//g'`
cps template-params-update --service neutron neutron-server --parameter extension_drivers=${current_extension_drivers// /}
cps commit

#notification_drivers
echo "cps_uninstall  3. uninstall notification_drivers..."
exists_notification_drivers=`sed '/^notification_drivers =/!d;s/.*=//' /etc/neutron/neutron.conf`
old_nf_drivers=${exists_notification_drivers// /}

if [[ $exists_notification_drivers == *huawei_ac_qos_driver,* ]]
then
	old_nf_drivers=`echo $old_nf_drivers | sed 's/huawei_ac_qos_driver//g' | sed 's/^,//' | sed 's/,$//'`
fi

if [[ $exists_notification_drivers == *message_queue* ]]
then
	old_nf_drivers=`echo $old_nf_drivers | sed 's/message_queue//g' | sed 's/^,//' | sed 's/,$//'`
fi     
cps template-params-update --service neutron neutron-server --parameter notification_drivers=$old_nf_drivers
cps commit

#exists_api_extensions_path
echo "cps_uninstall  4. uninstall api_extensions_path..."

PYTHON_SITE_PATH=$(python2 -c "import os,neutron; print(os.path.abspath(neutron.__file__))" 2>/dev/null |awk -F '/neutron' '{print $1}')
PYTHON_SITE_PATH=$(echo $PYTHON_SITE_PATH|grep python || python3 -c "import os,neutron; print(os.path.abspath(neutron.__file__))" 2>/dev/null |awk -F '/neutron' '{print $1}')

API_EXT_VPN=$PYTHON_SITE_PATH/neutron_vpnaas/extensions
API_EXT_FW=$PYTHON_SITE_PATH/neutron_fwaas/extensions
API_EXT_L2BR=$PYTHON_SITE_PATH/networking_huawei/drivers/ac/extensions/l2br
API_EXT_EX=$PYTHON_SITE_PATH/networking_cascading/exroute_extensions
API_EXT_SYNC=$PYTHON_SITE_PATH/networking_huawei/drivers/ac/extensions/sync

exists_api_extensions_path=`sed '/^api_extensions_path =/!d;s/.*=//' /etc/neutron/neutron.conf`
old_ext_api=${exists_api_extensions_path// /}

if [[ $exists_api_extensions_path == *:$API_EXT_VPN* ]]
then
	old_ext_api=`echo $old_ext_api | sed -e "s#$API_EXT_VPN:##g" | sed -e "s#:$API_EXT_VPN##g" | sed -e "s#$API_EXT_VPN##g"`
fi     

if [[ $exists_api_extensions_path == *:$API_EXT_FW* ]]
then
	old_ext_api=`echo $old_ext_api | sed -e "s#$API_EXT_FW:##g" | sed -e "s#:$API_EXT_FW##g" | sed -e "s#$API_EXT_FW##g"`
fi

if [[ $exists_api_extensions_path == *:$API_EXT_L2BR* ]]
then
	old_ext_api=`echo $old_ext_api | sed -e "s#$API_EXT_L2BR:##g" | sed -e "s#:$API_EXT_L2BR##g" | sed -e "s#$API_EXT_L2BR##g"`
fi

if [[ $exists_api_extensions_path == *:$API_EXT_EX* ]]
then
	old_ext_api=`echo $old_ext_api | sed -e "s#$API_EXT_EX:##g" | sed -e "s#:$API_EXT_EX##g" | sed -e "s#$API_EXT_EX##g"`
fi

if [[ $exists_api_extensions_path == *:$API_EXT_SYNC* ]]
then
	old_ext_api=`echo $old_ext_api | sed -e "s#$API_EXT_SYNC:##g" | sed -e "s#:$API_EXT_SYNC##g" | sed -e "s#$API_EXT_SYNC##g"`
fi

cps template-params-update --service neutron neutron-server --parameter api_extensions_path=$old_ext_api
cps commit;

sed -i "/.*--config-file=.*/s/[[:space:]]*--config-file=\/etc\/neutron\/huawei_driver_config.ini//g" /etc/neutron/neutron-server/SetState.sh

echo "restarting..."
cps host-template-instance-operate --service neutron neutron-server --action stop
cps host-template-instance-operate --service neutron neutron-server --action start
echo "restarted"
echo "cps_uninstall  uninstall complete!"
cps template-params-show --service neutron neutron-server
