#!/bin/bash
# Copyright 2021 Huawei Technologies Co. Ltd. All rights reserved.

PYTHON_PATH=$(python -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")
NETWORKING_HUAWEI=$PYTHON_PATH/networking_huawei
DRIVER_CONF=/etc/neutron/huawei_driver_config.ini

function select_cloud_platform(){
    echo "****Please select cloud platform****"
    echo "[1] openstack"
    echo "[2] CMCC_Pike or FSP before 6.3.0 (include)"
    echo "[3] FSP between 6.3.1 (include) and 8.0.0 (not include)"
    echo "[4] FSP after 8.0.0 (include)"
    while true; do
        echo -e "Press [1/2/3/4] to select cloud platform: \c"
        read OPENSTACK_VERSION
        case "$OPENSTACK_VERSION" in
        "1" | "2" | "3" | "4")
            break;;
        esac
    done
}

function select_openstack_version(){
    echo "****Please select openstack version****"
    echo "[1] Kilo"
    echo "[2] Liberty"
    echo "[3] Mitaka"
    echo "[4] Newton"
    echo "[5] Ocata"
    echo "[6] Pike"
    echo "[7] Queens"
    echo "[8] EZ_Mitaka"
    echo "[9] Rocky"
    echo "[10] CMCC_Pike"
    echo "[11] Train"
    echo "[12] Wallaby"
    while true; do
        echo -e "Press [1/2/3/4/5/6/7/8/9/10/11/12] to select openstack version: \c"
        read OPENSTACK_VERSION
        case "$OPENSTACK_VERSION" in
        "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "10" | "11" | "12")
            break;;
        esac
    done
}

function check_input()
{
    echo "Press [Y] to confirm or press [N] to give up #[Y/N]"
    read INPUT
    USER_INPUT=$INPUT
    while true
    do
        if [ "$USER_INPUT" == "y" ] || [ "$USER_INPUT" == "Y" ] || [ "$USER_INPUT" == "n" ] || [ "$USER_INPUT" == "N" ]; then
            break
        else
            echo "Press [Y] to confirm or press [N] to give up #[Y/N]"
            read INPUT
            USER_INPUT=$INPUT
            continue
        fi
    done
}

function source_fsp_env() {
    KEYSTONE_PASSWORD=`cat $DRIVER_CONF|grep '^keystone_passwd' |awk -F " = " '{print $2}'`
    DECRYPT_KEYSTONE_PASSWORD=$(python -c "from FSSecurity import crypt; print (crypt.decrypt('$KEYSTONE_PASSWORD'))")
    source set_env < <(echo 1;echo $DECRYPT_KEYSTONE_PASSWORD)
}

function get_keystone_passwd() {
    python -c '
import sys
import base64
import encryptor
from networking_huawei.drivers.ac.encode_convert import convert_to_bytes
print(base64.b64encode(convert_to_bytes(encryptor.encrypt_password(sys.argv[1], 2))))
' $1
}


function check_os_version() {
    if [ $OPENSTACK_VERSION -eq 12 -a $SYS_SELE  -ne 1 ]; then
        echo "Error: Wallaby only support CentOS"
        exit
    fi
}

function check_python_version() {
    echo "****Check python version****"
    python_version=$(python -c "import sys; print ('python-%s.%s.%s' % (sys.version_info.major, sys.version_info.minor, sys.version_info.micro))")
    if [ -z "${python_version}" ];then
        echo "Error: Failed to get python version"
        echo "The recommended python version is 'python2.7.5-58.el7.x86_64', OpenStack Wallaby recommended python version is 'python-3.6.8'"
        exit
    fi
    if [ $OPENSTACK_VERSION -eq 12 ]; then
        down_python="python-3.6.8"
        if ([[ $python_version < $down_python ]]); then
            echo "Error: The python version should not be lower than ${down_python}, please upgrade the python version"
            echo "The current python version is ${python_version}, recommended python version is ${down_python}"
            exit
        fi
        echo "The python version is ok"
    else
        if [[ "${python_version}" =~ "python-3" ]]; then
            echo "The python version is ok"
        else
            down_python="python-2.7.5-34"
            up_version="python-2.7.5-46"
            python_version=`rpm -qa | grep "python-2.7.5"`
            if ([[ $python_version < $up_version ]] || [[ $python_version == $up_version* ]]) && ([[ $python_version > $down_python ]] || [[ $python_version == $down_python* ]]); then
                echo "ERROR: The python version cannot be within the range of python-2.7.5-34 to python-2.7.5-46, please upgrade the python version"
                echo "The current python version is $python_version, recommended python version is 'python2.7.5-58.el7.x86_64'"
                exit
            fi
            echo "The python version is ok"
        fi
    fi
}

function remove_config() {
    item_key=$1
    config_file=$2
    sed -i '/^#'"${item_key}"'.*/{n;d}' $config_file
    sed -i '/^#'"${item_key}"'.*/d' $config_file
}