#!/bin/bash
#------------------------------------------------
#Example: bash container_dynamic_prepare.sh
#Description:: this script will be invoked by k8s to deploy neutron-server pod
#------------------------------------------------

HW_PACKAGES_PATH=/neutron_plugin_dir/hw_packages

WORK_PATH=/root

HUAWEI_DRIVER_BASE=/root/networking-huawei/etc/oslo-config-generator/huawei_driver.ini
HUAWEI_DRIVER_BASE_SAMPLE=/root/networking-huawei/etc/huawei_driver_config.ini.sample
HUAWEI_DRIVER_CONFIG_TXT=$HW_PACKAGES_PATH/networking_huawei_config.txt
HUAWEI_DRIVER_CONFIG_INI=/etc/neutron/huawei_driver_config.ini
WHITELIST_SAMPLE=/root/networking-huawei/tools/whitelist_sample.ini
CONTAINER_TOOL=/root/networking-huawei/tools/container_tool.sh

function LOG_INFO() {
    log_time=$(date +'%Y-%m-%d %H:%M:%S')
    echo "$log_time INFO $1" >>/var/log/neutron/container_dynamic_deploy.log
}

function RPM_INSTALL_PACKAGE() {
    LOG_INFO "install package $1"
    package_name=$(echo $1 | awk -F'.rpm' '{print $1}')
    flag=$(rpm -qa | grep "${package_name}")
    if [ -z "${flag}" ]; then
        LOG_INFO "installing..."
        rpm -ivh "$HW_PACKAGES_PATH/$1"
    fi
    LOG_INFO "$1 has been installed!"
}

function GET_CONFIG_PARAMS() {
    params_arr=()
    while read line; do
        if [[ "$line" =~ "=" && ! "$line" =~ ^# ]]; then
            param=$(echo $line | cut -d "=" -f 1 | sed s/[[:space:]]//g)
            params_arr=(${params_arr[*]} $param)
        fi
    done <$1
}

LOG_INFO "Step 1. Prepare system"
CURRENT_PATH=$(pwd)
if [ "$CURRENT_PATH" != "/root" ]; then
    mkdir -p $WORK_PATH
    cd $WORK_PATH
fi
RPM_INSTALL_PACKAGE libtommath-1.1.0-1.oe1.x86_64.rpm
RPM_INSTALL_PACKAGE libtomcrypt-1.18.2-4.oe1.x86_64.rpm
RPM_INSTALL_PACKAGE python2-crypto-2.6.1-26.oe1.x86_64.rpm
cp -p $HW_PACKAGES_PATH/start_neutron_server.sh /root

if [ -f "$HUAWEI_DRIVER_CONFIG_TXT" ]; then
    LOG_INFO "Step 2. Prepare neutron-server"
    rm -rf /root/networking-huawei*
    cp -r $HW_PACKAGES_PATH/networking-huawei /root/

    LOG_INFO "Step 3. Install neutron-server"
    cd /root/networking-huawei
    python setup.py install >/dev/null 2>&1
    PYTHON_PATH=$($CONTAINER_TOOL python_path)
    cp -p $HW_PACKAGES_PATH/ssl_cacert.pem $PYTHON_PATH/networking_huawei/drivers/ac/client/
    cp -p $HW_PACKAGES_PATH/client.cer $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket/
    cp -p $HW_PACKAGES_PATH/client_key.pem $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket/
    cp -p $HW_PACKAGES_PATH/trust.cer $PYTHON_PATH/networking_huawei/drivers/ac/ac_agent/rpc/websocket/

    LOG_INFO "Step 4. Upgrade neutron db"
    db_upgrade_result=$(neutron-db-manage --subproject networking-huawei upgrade head)
    LOG_INFO "$db_upgrade_result"

    LOG_INFO "Step 5. Generate networking_huawei_config.ini"
    oslo-config-generator --config-file $HUAWEI_DRIVER_BASE >/dev/null 2>&1
    sed -i '/^#.*value)$/d' $HUAWEI_DRIVER_BASE_SAMPLE
    sed -i '/^# From networking_huawei.ac_config/d' $HUAWEI_DRIVER_BASE_SAMPLE
    sed -i '/^#$/d' $HUAWEI_DRIVER_BASE_SAMPLE

    LOG_INFO "Step 6. Config networking_huawei_config.ini"
    GET_CONFIG_PARAMS $HUAWEI_DRIVER_CONFIG_TXT
    for param in ${params_arr[@]}; do
        value=$(grep ^$param $HUAWEI_DRIVER_CONFIG_TXT | cut -d "=" -f 1 --complement | sed s/^[[:space:]]// | sed s/[[:space:]]$//)
        if [[ -n "$value" ]]; then
            if [[ "$param" == "ac_auth_password" ]]; then
                pwd=$(python tools/encryptor.py "$value" 1)
                sed -i "s%[#]*$param.*%$param = $pwd%g" $HUAWEI_DRIVER_BASE_SAMPLE
            elif [[ "$param" == "keystone_passwd" ]]; then
                pwd=$(python tools/encryptor.py "$value" 2)
                sed -i "s%[#]*$param.*%$param = $pwd%g" $HUAWEI_DRIVER_BASE_SAMPLE
            elif [[ "$param" == "websocket_key_password" ]]; then
                pwd=$(python tools/encryptor.py "$value" 3)
                sed -i "s%[#]*$param.*%$param = $pwd%g" $HUAWEI_DRIVER_BASE_SAMPLE
            else
                sed -i "s%[#]*$param.*%$param = $value%g" $HUAWEI_DRIVER_BASE_SAMPLE
            fi
        fi
    done
    rm -rf $HUAWEI_DRIVER_CONFIG_TXT
    mv $HUAWEI_DRIVER_BASE_SAMPLE $HUAWEI_DRIVER_CONFIG_INI
    cp -f $WHITELIST_SAMPLE /etc/neutron/whitelist.ini
fi

LOG_INFO "Step 7. Run start_neutron_server.sh"
cd $WORK_PATH
