#!/bin/bash
#------------------------------------------------
#Example: bash container_dynamic_prepare.sh
#Description: this script generates the following file structure in /apps/:
#.
#└── neutron_plugin_dir
#    ├── container_dynamic_deploy.sh
#    └── hw_packages
#        ├── client.cer
#        ├── client_key.pem
#        ├── networking_huawei
#        ├── networking-huawei_config.txt
#        ├── ssl_cacert.pem
#        ├── start_neutron_server.sh
#        └── trust.cer
#------------------------------------------------

APP_RELEASE_PATH=/root
APP_CONFIG_PATH=/root/networking-huawei
HOST_PATH=/apps/neutron_plugin_dir
HOST_PKG_PATH=/apps/neutron_plugin_dir/hw_packages

if [ ! -d "$HOST_PKG_PATH" ]; then
    mkdir -p $HOST_PKG_PATH
fi

cp -p $APP_RELEASE_PATH/networking-huawei.tar.gz $HOST_PKG_PATH/
cp -p $APP_CONFIG_PATH/tools/networking_huawei_config.txt $HOST_PKG_PATH/
cp -p $APP_CONFIG_PATH/tools/container_dynamic_deploy.sh $HOST_PATH/
cp -p $APP_CONFIG_PATH/tools/start_neutron_server.sh $HOST_PKG_PATH/
cp -p $APP_CONFIG_PATH/tools/certs/ssl_cacert.pem $HOST_PKG_PATH/
cp -p $APP_CONFIG_PATH/tools/certs/client.cer $HOST_PKG_PATH/
cp -p $APP_CONFIG_PATH/tools/certs/client_key.pem $HOST_PKG_PATH/
cp -p $APP_CONFIG_PATH/tools/certs/trust.cer $HOST_PKG_PATH/

rm -rf $HOST_PKG_PATH/networking-huawei
tar -xzf $HOST_PKG_PATH/networking-huawei.tar.gz -C $HOST_PKG_PATH/
rm -rf $HOST_PKG_PATH/networking-huawei.tar.gz
