#!/bin/sh

CUR_PATH=$(dirname $(readlink -f $0))
source $CUR_PATH/common_function.sh

PYTHON_SITE_PATH=$(python2 -c "import os,neutron; print(os.path.abspath(neutron.__file__))" 2>/dev/null |awk -F '/neutron' '{print $1}')
PYTHON_SITE_PATH=$(echo $PYTHON_SITE_PATH|grep python || python3 -c "import os,neutron; print(os.path.abspath(neutron.__file__))" 2>/dev/null |awk -F '/neutron' '{print $1}')
API_EXROUTE_CUSTOM=${PYTHON_SITE_PATH}/networking_huawei/drivers/ac/extensions/exroute_custom

echo -e '+ Begin to install extension plugins:'
echo "Press ENV password"
read -s password
source set_env << EOF > /dev/null 2>&1
1
$password
EOF

cps template-params-show --service neutron neutron-server > /dev/null 2>&1
if [ $? -ne 0 ]; then
    echo "ENV password is error"
    exit 1
fi

cd /etc/neutron/
if [ ! -f neutron.conf ]; then
    echo "neutron.conf does not exist."
    exit 1
fi

cp neutron.conf neutron.conf.backup

current_service_plugins=`sed '/^service_plugins =/!d;s/.*=//' /etc/neutron/neutron.conf`
for ((i=1;i<=6;i++)); do
    # check huawei_ac_router exist or not.
    if [[ $current_service_plugins =~ _router ]]; then
        break
    fi
    if [[ ${i} -eq 6 ]]; then
        echo "Controller plugin install not finished, please install it at first."
        exit 1
    fi
    sleep 10
    current_service_plugins=`sed '/^service_plugins =/!d;s/.*=//' /etc/neutron/neutron.conf`
done

current_service_plugins=`sed '/^service_plugins =/!d;s/.*=//' /etc/neutron/neutron.conf`
update_service_plugins=${current_service_plugins// /}

exists_api_extensions_path=`sed '/^api_extensions_path =/!d;s/.*=//' /etc/neutron/neutron.conf`
update_ext_api=${exists_api_extensions_path// /}


# confirm to config trunk plugin
echo "Confirm to config trunk plugin(Please ensure trunk plugin installed)"
check_input
INSTALL_TRUNK=$USER_INPUT
if [ "$INSTALL_TRUNK" == "y" ] || [ "$INSTALL_TRUNK" == "Y" ]; then
    if [[ $current_service_plugins =~ trunk ]]; then
        echo -e "\033[31m trunk plugin already install \033[0m"
    else
        update_service_plugins=$update_service_plugins,trunk
    fi
fi

# confirm to config huawei_ac_bgp_route plugin
echo "Confirm to config bgp route plugin(Please ensure bgp route installed)"
check_input
INSTALL_BGP_ROUTE=$USER_INPUT
if [ "$INSTALL_BGP_ROUTE" == "y" ] || [ "$INSTALL_BGP_ROUTE" == "Y" ]; then
    if [[ $current_service_plugins =~ huawei_ac_bgp_route ]]; then
        echo -e "\033[31m bgp route plugin already install \033[0m"
    else
        update_service_plugins=$update_service_plugins,huawei_ac_bgp_route
    fi
fi

# confirm to config huawei_ac_bgpneighbor plugin
echo "Confirm to config bgpneighbor plugin(Please ensure  bgpneighbor installed, CMCC Custom interface)"
check_input
INSTALL_BGPNEIGHBOR=$USER_INPUT
if [ "$INSTALL_BGPNEIGHBOR" == "y" ] || [ "$INSTALL_BGPNEIGHBOR" == "Y" ]; then
    if [[ $current_service_plugins =~ huawei_ac_bgpneighbor ]]; then
        echo -e "\033[31m bgpneighbor plugin already install \033[0m"
    else
        update_service_plugins=$update_service_plugins,huawei_ac_bgpneighbor
    fi
fi

# confirm to config huawei_ac_custom_vpc_connection plugin
echo "Confirm to config custom vpc connection plugin(Please ensure custom vpc connection installed, CMCC Custom interface)"
check_input
INSTALL_CUSTOM_VPC_CONNECTION=$USER_INPUT
if [ "$INSTALL_CUSTOM_VPC_CONNECTION" == "y" ] || [ "$INSTALL_CUSTOM_VPC_CONNECTION" == "Y" ]; then
    if [[ $current_service_plugins =~ huawei_ac_custom_vpc_connection ]]; then
        echo -e "\033[31m custom vpc connection already install \033[0m"
    else
        update_service_plugins=$update_service_plugins,huawei_ac_custom_vpc_connection
    fi
fi

# confirm to config exroute_custom plugin
echo "Confirm to config exroute custom plugin(Please ensure exroute_custom installed, CMCC Custom interface)"
check_input
INSTALL_EXROUTE_CUSTOM=$USER_INPUT
if [ "$INSTALL_EXROUTE_CUSTOM" == "y" ] || [ "$INSTALL_EXROUTE_CUSTOM" == "Y" ]; then
    if [[ $exists_api_extensions_path =~ exroute_custom ]]; then
        echo -e "\033[31m exroute custom already install \033[0m"
    else
        update_ext_api=$update_ext_api:$API_EXROUTE_CUSTOM
    fi
fi

# confirm to config bfd ex-route plugin
echo "Confirm to config bfd ex-route plugin(Please ensure bfd ex-route installed, CMCC Custom interface)"
check_input
INSTALL_BFD_EX_ROUTE=$USER_INPUT
if [ "$INSTALL_BFD_EX_ROUTE" == "y" ] || [ "$INSTALL_BFD_EX_ROUTE" == "Y" ]; then
    if [[ $current_service_plugins =~ huawei_ac_bfd_route ]]; then
        echo -e "\033[31m bfd ex-route already install \033[0m"
    else
        update_service_plugins=$update_service_plugins,huawei_ac_bfd_route
        update_ext_api=$update_ext_api:${PYTHON_SITE_PATH}/networking_huawei/drivers/ac/extensions/bfd_route
    fi
fi

# confirm to config dry-run plugin
echo "Confirm to config dry-run plugin(Please ensure dry-run installed, CMCC Custom interface)"
check_input
INSTALL_DRY_RUN=$USER_INPUT
if [ "$INSTALL_DRY_RUN" == "y" ] || [ "$INSTALL_DRY_RUN" == "Y" ]; then
    if [[ $current_service_plugins =~ huawei_ac_dry_run_task ]]; then
        echo -e "\033[31m dry-run already install \033[0m"
    else
        update_service_plugins=$update_service_plugins,huawei_ac_dry_run_task
        update_ext_api=$update_ext_api:${PYTHON_SITE_PATH}/networking_huawei/drivers/ac/extensions/dry_run
    fi
fi

# confirm to config huawei_ac_external_whitelist plugin
echo "Confirm to config external whitelist plugin(Please ensure external whitelist installed)"
check_input
INSTALL_EXTERNAL_WHITELIST=$USER_INPUT
if [ "$INSTALL_EXTERNAL_WHITELIST" == "y" ] || [ "$INSTALL_EXTERNAL_WHITELIST" == "Y" ]; then
    if [[ $current_service_plugins =~ huawei_ac_external_whitelist ]]; then
        echo -e "\033[31m external whitelist plugin already install \033[0m"
    else
        update_service_plugins=$update_service_plugins,huawei_ac_external_whitelist
    fi
fi

# confirm to config huawei_ac_flow_mirror plugin
echo "Confirm to config flow mirror plugin(Please ensure flow mirror installed)"
check_input
INSTALL_FLOW_MIRROR=$USER_INPUT
if [ "$INSTALL_FLOW_MIRROR" == "y" ] || [ "$INSTALL_FLOW_MIRROR" == "Y" ]; then
    if [[ $current_service_plugins =~ huawei_ac_flow_mirror ]]; then
        echo -e "\033[31m flow mirror plugin already install \033[0m"
    else
        update_service_plugins=$update_service_plugins,huawei_ac_flow_mirror
    fi
fi

if [ $current_service_plugins != $update_service_plugins ]; then
    cps template-params-update --service neutron neutron-server --parameter service_plugins=$update_service_plugins
fi

if [ $exists_api_extensions_path != $update_ext_api ]; then
    cps template-params-update --service neutron neutron-server --parameter api_extensions_path=$update_ext_api
fi
cps commit
sleep 10

echo -e '+ Config functions of controll-pulgin done!'
