#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""upgrade backup tool"""

from __future__ import print_function
import os
from distutils.sysconfig import get_python_lib, get_python_version
import six
try:
    import commands
except ImportError:
    import subprocess as commands

VERSION_LIST = ['v3r19c00', 'v1r19c10']

PYTHON_VERSION = get_python_version()

CODE_MAIN_NAME = 'networking_huawei'
CODE_MAIN_NAME_INFO = \
    'networking_huawei-3.1.0-py' + PYTHON_VERSION + '.egg-info'
BACK_FILE_LIST = ['/etc/neutron/huawei_driver_config.ini',
                  '/etc/neutron/neutron.conf',
                  '/etc/neutron/plugins/ml2/ml2_conf.ini',
                  '/etc/neutron/whitelist.ini']

def choose_version():
    """choose_version"""
    print('-' * 50)
    print('backup config starting...')
    print('-' * 50)
    print('choose the current plugin_version '
          'in your system below(1,2,3...).')
    print('-' * 50)
    version_id = 1
    for version in VERSION_LIST:
        print("[%d] ==> %s\n" % (version_id, version))
        version_id += 1
    print('-' * 50)
    # catch input number
    choose = six.moves.input("you choose:")
    num = 0
    try:
        num = int(choose)
    except ValueError:
        print("unknown input : %s catch an exception" % choose)
        exit(1)
    if num not in six.moves.range(1, version_id):
        print("unknown input : %s" % choose)
        exit(1)
    return VERSION_LIST[num - 1]


def excu_cmd(bak_file_list, version):
    """excu_cmd"""
    for resource in bak_file_list:
        cmd = r"\cp -af {} {}.{}".format(resource, resource, version)
        status, output = commands.getstatusoutput(cmd)
        if status:
            print(output)
            exit(1)
    print('-' * 50)
    print("Backing Up Files Seccess")


def get_bak_file_list():
    """get_bak_file_list"""
    python_lib = get_python_lib()
    bak_file_list = BACK_FILE_LIST
    if os.path.isdir(python_lib):
        bak_file_list.append('{}/{}'.format(python_lib, CODE_MAIN_NAME))
        bak_file_list.append('{}/{}'.format(python_lib, CODE_MAIN_NAME_INFO))
    else:
        print("Can not find the path: %s" % python_lib)
        exit(1)
    return bak_file_list


def show_details(file_path_list, version):
    """show_details"""
    print('-' * 50)
    print("details:")
    for file_path in file_path_list:
        print('{}  ==>  {}.{}'.format(file_path, file_path, version))


def bak_item():
    """bak_item"""
    bak_file_list = get_bak_file_list()
    version = choose_version()
    show_details(bak_file_list, version)
    excu_cmd(bak_file_list, version)


if __name__ == '__main__':
    bak_item()
