#!/bin/bash
#------------------------------------------------
#功能：插件升级（R19C00->R22C00）后，配置恢复。
#适用范围:
#<1> openstack插件,手动卸载重装方式升级
#<2> fusionsphere插件，cps界面卸载重装方式升级
#------------------------------------------------

BAK_VERSION=$1

PlUGIN_VERSIONS=(
"v1r19c10"
)

if [[ -z ${BAK_VERSION} ]] || [[ ! ${PlUGIN_VERSIONS[@]} =~ $BAK_VERSION ]]; then
    echo "Please input a correct plugin version in: [${PlUGIN_VERSIONS[@]}]"
    exit 1
fi

CUR_PATH=$(dirname $(readlink -f $0))
NEUTRON_CONF_PATH=/etc/neutron
NEUTRON_CONF=$NEUTRON_CONF_PATH/neutron.conf
ML2_CONF=$NEUTRON_CONF_PATH/plugins/ml2/ml2_conf.ini
DRIVER_CONF=$NEUTRON_CONF_PATH/huawei_driver_config.ini
WHITE_LIST=$NEUTRON_CONF_PATH/whitelist.ini

NEUTRON_CONF_BAK=$NEUTRON_CONF_PATH/neutron.conf.$BAK_VERSION
ML2_CONF_BAK=$NEUTRON_CONF_PATH/plugins/ml2/ml2_conf.ini.$BAK_VERSION
DRIVER_CONF_BAK=$NEUTRON_CONF_PATH/huawei_driver_config.ini.$BAK_VERSION
WHITE_LIST_BAK=$NEUTRON_CONF_PATH/whitelist.ini.$BAK_VERSION

ZK_SERVICE_CACHE_PARSER_FILE='/usr/bin/install_tool/zk_cache_cfg_parser.py'

python_version_env=`python -c "from distutils.sysconfig import get_python_version; print(get_python_version())"`
UBUNTU_PYTHON_PATH=/usr/local/lib/python$python_version_env/dist-packages

PYTHON_PATH=$(python -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")
NETWORKING_HUAWEI_CONF=$PYTHON_PATH/networking_huawei/drivers/ac/common/config.py
NETWORKING_HUAWEI=$PYTHON_PATH/networking_huawei
NETWORKING_HUAWEI_BAK=$PYTHON_PATH/networking_huawei.v1r19c10
UBUNTU_HUAWEI_CONF=$UBUNTU_PYTHON_PATH/networking_huawei/drivers/ac/common/config.py
if [ ! -e $NETWORKING_HUAWEI_CONF ] && [ -e $UBUNTU_HUAWEI_CONF ]; then
    NETWORKING_HUAWEI_CONF=$UBUNTU_HUAWEI_CONF
fi

IGNORE_PARAMS=(
"ac_auth_username"
"ac_auth_password"
"keystone_tenant"
"keystone_user"
"keystone_passwd"
"websocket_key_password"
)

function get_conf_params(){
    params_arr=()
    while read line; do
        if [[ $line =~ cfg\..*Opt.* ]]; then
            new_param=`echo $line | sed "s/.*'\([a-zA-Z0-9_]*\)',.*/\1/"`
            params_arr=(${params_arr[*]} $new_param)
        fi
    done < $NETWORKING_HUAWEI_CONF
}

function get_char(){
    stty cbreak -echo
    dd if=/dev/tty bs=1 count=1 2>/dev/null
    stty -cbreak echo
}

ops_version=`grep ^OPS_version $DRIVER_CONF_BAK`
get_conf_params
if [[ $ops_version =~ "FusionSphere" ]]; then
    DC_ADMIN_NAME=`python $ZK_SERVICE_CACHE_PARSER_FILE -s cps -t cps-web -c dc_admin_name`
    echo -e "+ Please input ${DC_ADMIN_NAME}_admin password: \c"
    while :; do
        ret=`get_char`
        if [ x$ret = x ]; then
            echo
            break
        fi
        password="$password$ret"
    done
    source set_env << EOF > /dev/null
    1
    $password
EOF
fi

echo "****Begin to config /etc/neutron/huawei_driver_config.ini****"
if [[ ! $ops_version =~ "FusionSphere" ]] || [[ $ops_version =~ "FusionSphere6.1" ]] || [[ $ops_version =~ "FusionSphere6.3.0" ]]; then
    for param in ${params_arr[@]}; do
        param_name=`echo $param | sed s/[[:space:]]//g`
        if [[ ! -z $param_name && -e $DRIVER_CONF_BAK ]]; then
            huawei_param_bak=`grep ^$param_name $DRIVER_CONF_BAK | awk -F = '{print $2}' | sed s/[[:space:]]//g`
            if [ ! -z $huawei_param_bak ] && [[ ! `echo ${IGNORE_PARAMS[@]}|grep -w $param_name` ]]; then
                echo "    Set parameter $param_name to value: $huawei_param_bak"
                if [[ `grep ^$param_name $DRIVER_CONF` ]];then
                    sed -i "s/^\($param_name =\).*/\1 ${huawei_param_bak//\//\\/}/" $DRIVER_CONF
                else
                    sed -i "s/#\($param_name =\).*/\1 ${huawei_param_bak//\//\\/}/" $DRIVER_CONF
                fi
            fi
        fi
    done
else
    echo "    Cps saved huawei ac config, no need update."
fi
echo "****End to config /etc/neutron/huawei_driver_config.ini****"
echo ''

echo "****Begin to config /etc/neutron/whitelist.ini****"
if [[ -e $WHITE_LIST_BAK ]]; then
    echo "    Exec: cp -af $WHITE_LIST_BAK $WHITE_LIST"
    cp -af $WHITE_LIST_BAK $WHITE_LIST
    cat $WHITE_LIST|grep 'ipv6-ns-qos-policies' || sed -i  "/external-policy-groups/a\    \'ipv6-ns-qos-policies\': []," $WHITE_LIST
    cat $WHITE_LIST|grep 'tap-services' || sed -i  "/ipv6-ns-qos-policies/a\    \'tap-services\': []," $WHITE_LIST
    cat $WHITE_LIST|grep 'tap-flows' || sed -i  "/ipv6-ns-qos-policies/a\    \'tap-flows\': []," $WHITE_LIST
fi
echo "****End to config /etc/neutron/whitelist.ini****"
echo ''

echo "****Begin to config /etc/neutron/neutron.conf****"
if [[ -e $NEUTRON_CONF_BAK ]]; then
    if [[ ! $ops_version =~ "FusionSphere" ]]; then
        echo "    Exec: cp -af $NEUTRON_CONF_BAK $NEUTRON_CONF"
        cp -af $NEUTRON_CONF_BAK $NEUTRON_CONF
    else
        service_plugins_bak=`cat $NEUTRON_CONF_BAK|grep '^service_plugin'|awk -F = '{print $2}' | sed s/[[:space:]]//g`
        service_plugins_curr=`cat $NEUTRON_CONF|grep '^service_plugin'|awk -F = '{print $2}' | sed s/[[:space:]]//g`
        if [[ $service_plugins_bak != $service_plugins_curr ]];then
            echo "    Exec: cps template-params-update --service neutron neutron-server --parameter service_plugins=$service_plugins_bak"
            cps template-params-update --service neutron neutron-server --parameter service_plugins=$service_plugins_bak
            cps commit
        fi

        api_extensions_path_bak=`cat $NEUTRON_CONF_BAK|grep '^api_extensions_path'|awk -F = '{print $2}' | sed s/[[:space:]]//g`
        api_extensions_path_curr=`cat $NEUTRON_CONF|grep '^api_extensions_path'|awk -F = '{print $2}' | sed s/[[:space:]]//g`
        if [[ $api_extensions_path_bak != $api_extensions_path_curr ]];then
            echo "    Exec: cps template-params-update --service neutron neutron-server --parameter api_extensions_path=$api_extensions_path_bak"
            cps template-params-update --service neutron neutron-server --parameter api_extensions_path=$api_extensions_path_bak
            cps commit
        fi

        notification_drivers_bak=`cat $NEUTRON_CONF_BAK|grep '^notification_drivers'|awk -F = '{print $2}' | sed s/[[:space:]]//g`
        notification_drivers_curr=`cat $NEUTRON_CONF|grep '^notification_drivers'|awk -F = '{print $2}' | sed s/[[:space:]]//g`
        if [[ $notification_drivers_bak != $notification_drivers_curr ]];then
            echo "    Exec: cps template-params-update --service neutron neutron-server --parameter notification_drivers=$notification_drivers_bak"
            cps template-params-update --service neutron neutron-server --parameter notification_drivers=$notification_drivers_bak
            cps commit
        fi
    fi
fi
echo "****End to config /etc/neutron/neutron.conf****"
echo ''

echo "****Begin to config /etc/neutron/plugins/ml2/ml2_conf.ini****"
if [[ -e $ML2_CONF_BAK ]]; then
    if [[ ! $ops_version =~ "FusionSphere" ]]; then
        echo "    Exec: cp -af $ML2_CONF_BAK $ML2_CONF"
        cp -af $ML2_CONF_BAK $ML2_CONF
    else
        extension_drivers_bak=`cat $ML2_CONF_BAK|grep '^extension_drivers'|awk -F = '{print $2}' | sed s/[[:space:]]//g`
        extension_drivers_curr=`cat $ML2_CONF|grep '^extension_drivers'|awk -F = '{print $2}' | sed s/[[:space:]]//g`
        if [[ $extension_drivers_bak != $extension_drivers_curr ]];then
            echo "    Exec: cps template-params-update --service neutron neutron-server --parameter extension_drivers=$extension_drivers_bak"
            cps template-params-update --service neutron neutron-server --parameter extension_drivers=$extension_drivers_bak
            cps commit
        fi
    fi
fi
echo "****End to config /etc/neutron/plugins/ml2/ml2_conf.ini****"
echo ''

echo "****Begin to recover certs****"
if [[ ! $ops_version =~ "FusionSphere8.0" ]]; then
    cp -af $NETWORKING_HUAWEI_BAK/drivers/ac/client/ssl_cacert.pem $NETWORKING_HUAWEI/drivers/ac/client/
    cp -af $NETWORKING_HUAWEI_BAK/drivers/ac/ac_agent/rpc/websocket/trust.cer $NETWORKING_HUAWEI/drivers/ac/ac_agent/rpc/websocket/
    cp -af $NETWORKING_HUAWEI_BAK/drivers/ac/ac_agent/rpc/websocket/client.cer $NETWORKING_HUAWEI/drivers/ac/ac_agent/rpc/websocket/
    cp -af $NETWORKING_HUAWEI_BAK/drivers/ac/ac_agent/rpc/websocket/client_key.pem $NETWORKING_HUAWEI/drivers/ac/ac_agent/rpc/websocket/
else
    SSL_CACERT=`cat $NETWORKING_HUAWEI_BAK/drivers/ac/client/ssl_cacert.pem`
    TRUST_CERT=`cat $NETWORKING_HUAWEI_BAK/drivers/ac/ac_agent/rpc/websocket/trust.cer`
    WEBSOCKET_PUBLIC_KEY=`cat $NETWORKING_HUAWEI_BAK/drivers/ac/ac_agent/rpc/websocket/client.cer`
    SSL_CACERT_FLAG=`cat $DRIVER_CONF|grep '^https_ca_cert'|awk -F = '{print $1}'`
    TRUST_CERT_FLAG=`cat $DRIVER_CONF|grep '^websocket_ca_cert'|awk -F = '{print $1}'`
    WEBSOCKET_PUBLIC_KEY_FLAG=`cat $DRIVER_CONF|grep '^websocket_public_key'|awk -F = '{print $1}'`
    if [[ $SSL_CACERT_FLAG ]]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.https_ca_cert="$TRUST_CERT"
    else
        cps template-ext-params-add --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.https_ca_cert="$TRUST_CERT"
    fi
    if [[ $TRUST_CERT_FLAG ]]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_ca_cert="$TRUST_CERT"
    else
        cps template-ext-params-add --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_ca_cert="$TRUST_CERT"
    fi
    if [[ $WEBSOCKET_PUBLIC_KEY_FLAG ]]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_public_key="$WEBSOCKET_PUBLIC_KEY"
    else
        cps template-ext-params-add --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_public_key="$WEBSOCKET_PUBLIC_KEY"
    fi
fi
echo "****End to recover certs****"
echo ''

echo "****Begin to config websocket private key password****"
if [[ ! $ops_version =~ "FusionSphere" ]] || [[ $ops_version =~ "FusionSphere6.1" ]] || [[ $ops_version =~ "FusionSphere6.3.0" ]]; then
    WEBSOCKET_KEY_PASSWORD=`grep 'websocket_key_password' $DRIVER_CONF_BAK`
    sed -i "s#websocket_key_password.=.*#$WEBSOCKET_KEY_PASSWORD#g" /etc/neutron/huawei_driver_config.ini
    cp -fp $NETWORKING_HUAWEI_BAK/drivers/ac/cryptor/decrypt_dependency_websocket.txt $NETWORKING_HUAWEI/drivers/ac/cryptor/decrypt_dependency_websocket.txt
fi
echo "****End to config websocket private key password****"
echo ''

echo '****Restart neutron-server****'
if [[ $ops_version =~ "FusionSphere" ]]; then
    cps commit
    cps host-template-instance-operate --service neutron neutron-server --action stop
    cps host-template-instance-operate --service neutron neutron-server --action start
    net_list_txt=$(neutron net-list)
    version_txt=$(neutron acctrl --query-version)
    echo "${version_txt}"
    echo "${net_list_txt}"
else
    service neutron-server restart
    net_list_txt=$(neutron net-list)
    version_txt=$(neutron acctrl --query-version)
    echo "${version_txt}"
    echo "${net_list_txt}"
fi