#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""decorator"""


from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging

LOG = logging.getLogger(__name__)


class Singleton(type):
    """Singleton"""
    def __call__(cls, *args, **kwargs):
        if not hasattr(cls, '_instance'):
            cls._instance = super(Singleton, cls).\
                __call__(*args, **kwargs)

        return cls._instance
