#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""rpc client handler"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging

from networking_huawei._i18n import _LI

LOG = logging.getLogger(__name__)


class ServerAware(object):
    """ServerAware"""
    def __init__(self):
        pass

    def added(self, terminal):
        """added"""
        pass

    def removed(self, terminal):
        """removed"""
        pass


class RpcClientHandler(ServerAware):
    """Rpc Client Handler"""
    def __init__(self, add_callback, remove_callback):
        self.add_callback = add_callback
        self.remove_callback = remove_callback
        super(RpcClientHandler, self).__init__()

    def added(self, terminal):
        """added"""
        LOG.info(_LI("[AC]Rpc client add terminal, address: %s"),
                 terminal.address)
        if self.add_callback:
            self.add_callback(terminal)

    def removed(self, terminal):
        """removed"""
        LOG.info(_LI("[AC]Rpc client remove terminal, address: %s"),
                 terminal.address)

        if self.remove_callback:
            self.remove_callback(terminal)
