#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.

"""
    ac common db Mixin class
"""

from neutron_lib.db import utils as db_utils
try:
    from neutron_lib.db import model_query
except ImportError:
    from neutron.db import _model_query as model_query
try:
    from neutron_lib.db import resource_extend
except ImportError:
    from neutron.db import _resource_extend as resource_extend


class CommonDbMixin(object):
    """Ac Db Mixin"""
    @staticmethod
    def _fields(resource, fields):
        """fields"""
        return db_utils.resource_fields(resource, fields)

    @staticmethod
    def _model_query(context, model):
        """model query"""
        return model_query.query_with_hooks(context, model)

    @staticmethod
    def _get_by_id(context, model, id):
        """get data by id"""
        return model_query.get_by_id(context, model, id)

    @staticmethod
    def _get_collection_query(context, model, filters=None, sorts=None,
                              limit=None, marker_obj=None, page_reverse=False):
        """get collection query"""
        return model_query.get_collection_query(context, model, filters,
                                                sorts, limit, marker_obj,
                                                page_reverse)

    @staticmethod
    def _get_collection(context, model, dict_func, filters=None, fields=None,
                        sorts=None, limit=None, marker_obj=None,
                        page_reverse=False):
        """get collection"""
        return model_query.get_collection(context, model, dict_func,
                                          filters, fields, sorts, limit,
                                          marker_obj, page_reverse)

    @staticmethod
    def _get_collection_count(context, model, filters=None):
        """get collection count"""
        return model_query.get_collection_count(context, model, filters)

    @staticmethod
    def _apply_dict_extend_functions(resource_type, response, db_object):
        """apply dict extend functions"""
        resource_extend.apply_funcs(resource_type, response, db_object)
