#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.

"""
Setting configuration parameters in a global variables
"""

from oslo_config import cfg
from networking_huawei.drivers.ac.common import constants as ac_const

HUAWEI_AC_DRIVER_OPTS = [
    cfg.StrOpt('ac_auth_username', required=True),
    cfg.StrOpt('ac_auth_password', secret=True, required=True),
    cfg.StrOpt('websocket_key_password', secret=True, required=True),
    cfg.StrOpt('cloud_name', required=True),
    cfg.StrOpt('OPS_version', default=ac_const.OPS_L),
    cfg.BoolOpt('cmcc_env', default=False),
    cfg.StrOpt('physical_network', default=''),
    cfg.StrOpt('keystone_tenant', default='admin'),
    cfg.StrOpt('keystone_user', default='admin'),
    cfg.StrOpt('keystone_passwd', secret=True, required=True),
    cfg.StrOpt('auth_url', default='http://controller:35357'),
    cfg.StrOpt('domain_id', default='None'),
    cfg.StrOpt('user_domain_id', default='None'),
    cfg.StrOpt('project_domain_id', default='None'),
    cfg.StrOpt('nova_client_auth_method', default='keystoneclient'),
    cfg.IntOpt('request_timeout', default=110),
    cfg.IntOpt('timeout_retry', default=0),
    cfg.IntOpt('token_retry', default=3),
    cfg.IntOpt('ac_response_time', default=300),
    cfg.IntOpt('error_retry_interval', default=180),
    cfg.IntOpt('error_retry_count', default=1),
    cfg.BoolOpt('enable_snat', default=True),
    cfg.BoolOpt('exroute_custom', default=False),
    cfg.StrOpt('neutron_sync_time', default='02:00:00'),
    cfg.StrOpt('neutron_sync_type', default='none'),
    cfg.BoolOpt('neutron_sync_enable_white_list', default=True),
    cfg.IntOpt('ac_detect_period', default=60),
    cfg.BoolOpt('vhost_user', default=False),
    cfg.IntOpt('security_group_sync_times', default=1),
    cfg.BoolOpt('enable_security_group', default=True),
    cfg.ListOpt('logical_hostnames', default=[]),
    cfg.ListOpt('vcenter_host_mappings', default=[]),
    cfg.ListOpt('vcenter_cluster_mappings', default=[]),
    cfg.ListOpt('vcenter_network_mappings', default=[]),
    cfg.StrOpt('external_access_mode', default=ac_const.GLOBAL_SNAT),
    cfg.ListOpt('network_black_list',
                default=['external_om', 'external_api', 'internal_base']),
    cfg.ListOpt('network_white_list', default=[]),
    cfg.StrOpt('network_list_matching', default='suffix'),
    cfg.BoolOpt('primary_interface', default=False),
    cfg.BoolOpt('vpc_peering', default=False),
    cfg.IntOpt('bare_metal_bond_mode', default=ac_const.BOND_MODE_1),
    cfg.ListOpt('public_service_networks', default=[]),
    cfg.StrOpt('default_public_service_network', default=''),
    cfg.ListOpt('LB_host_mappings', default=[]),
    cfg.ListOpt('allocate_vlan_ranges', default=[]),
    cfg.BoolOpt('enable_ce1800v_dhcp', default=False),
    cfg.StrOpt('https_ca_cert', default=''),
    cfg.StrOpt('websocket_ca_cert', default=''),
    cfg.StrOpt('websocket_public_key', default=''),
    cfg.StrOpt('websocket_private_key', default=''),
    cfg.IntOpt('cert_expiration_warning_time', default=30),
    cfg.BoolOpt('edge_dc', default=False)
]

cfg.CONF.register_opts(HUAWEI_AC_DRIVER_OPTS, "huawei_ac_config")


HUAWEI_AC_AGENT_OPT = [
    cfg.StrOpt('rpc_server_ip',),
    cfg.StrOpt('host_ip',),
]


cfg.CONF.register_opts(HUAWEI_AC_AGENT_OPT, "huawei_ac_agent_config")
