#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""ACProcStatusSchema class """


import sqlalchemy as sa

try:
    from neutron.db import model_base
except ImportError:
    from neutron_lib.db import model_base


class ACProcStatusSchema(model_base.BASEV2):
    """ACProcStatusSchema"""
    __tablename__ = 'huawei_ac_proc_status'

    id = sa.Column('id', sa.String(36), primary_key=True, nullable=False)
    type = sa.Column('type', sa.String(100), nullable=True)
    ac_proc_status = sa.Column('ac_proc_status', sa.String(10), nullable=False)
