#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""bgp route schema"""


import sqlalchemy as sa

try:
    from neutron.db import model_base
except ImportError:
    from neutron_lib.db import model_base
from oslo_utils import uuidutils


class ACBgpRouteSchema(model_base.BASEV2):
    """ACBgpRouteSchema"""
    __tablename__ = 'huawei_ac_bgp_route'
    id = sa.Column(sa.String(36),
                   primary_key=True,
                   default=uuidutils.generate_uuid)
    tenant_id = sa.Column(sa.String(36), nullable=False)
    name = sa.Column(sa.String(255), nullable=False)
    description = sa.Column(sa.String(255))
    router_id = sa.Column(sa.String(36), nullable=False)
    router_interface_id = sa.Column(sa.String(255), nullable=False)
    exsubnet_id = sa.Column(sa.String(36), nullable=True)
    local_as_number = sa.Column(sa.String(36), nullable=True)
    peer_ip_address = sa.Column(sa.String(64), nullable=False)
    peer_as_number = sa.Column(sa.String(36), nullable=False)
    ip_version = sa.Column(sa.Integer(), nullable=True)
    bfd = sa.Column(sa.Boolean, nullable=True)
    source_ips = sa.Column(sa.PickleType(protocol=2), nullable=True)
    session_attribute = sa.Column(sa.PickleType(protocol=2), nullable=True)
    peer_type = sa.Column(sa.Integer(), nullable=True)
