#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
""" flow mirror schema """

import sqlalchemy as sa

try:
    from neutron.db import model_base
except ImportError:
    from neutron_lib.db import model_base


class ACTapServiceSchema(model_base.BASEV2):
    """ AC TapService Schema """
    __tablename__ = 'huawei_ac_tap_services'
    id = sa.Column(sa.String(48),
                   primary_key=True)
    tenant_id = sa.Column(sa.String(48), nullable=False)
    name = sa.Column(sa.String(255), nullable=False)
    description = sa.Column(sa.String(255), nullable=False)
    port_id = sa.Column(sa.String(48), nullable=True)
    remote_v4ip = sa.Column(sa.String(32), nullable=True)
    remote_v6ip = sa.Column(sa.String(48), nullable=True)


class ACTapFlowSchema(model_base.BASEV2):
    """ AC TapFlow Schema """
    __tablename__ = 'huawei_ac_tap_flows'
    id = sa.Column(sa.String(48),
                   primary_key=True)
    tenant_id = sa.Column(sa.String(48), nullable=False)
    name = sa.Column(sa.String(255), nullable=False)
    description = sa.Column(sa.String(255), nullable=False)
    source_port = sa.Column(sa.String(48), nullable=False)
    destination_v4ip_prefix = sa.Column(sa.String(32), nullable=True)
    destination_v6ip_prefix = sa.Column(sa.String(48), nullable=True)
    direction = sa.Column(sa.String(5), nullable=False)
    tap_service_id = sa.Column(sa.String(48), nullable=True)
    sdn_tapservice_name = sa.Column(sa.String(255), nullable=True)
