#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""lock model"""

import sqlalchemy as sa
try:
    from neutron.db import model_base
except ImportError:
    from neutron_lib.db import model_base


class DBLockedObjects(model_base.BASEV2):
    """DBLockedObjects"""
    __tablename__ = 'huawei_ac_locked_objects'

    object_uuid = sa.Column(sa.String(36), primary_key=True)
    lock = sa.Column(sa.Boolean, default=False)
    lock_session_id = sa.Column(sa.BigInteger, default=0)
    created_at = sa.Column(sa.DateTime)
