#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: f90393fc56f7
Revises: e3666a7c91f5
Create Date: 2018-04-17 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

# revision identifiers, used by Alembic.
revision = 'f90393fc56f7'
down_revision = 'e3666a7c91f5'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Create table huawei_ac_neutron_sync.
    """
    if not migration.schema_has_table('huawei_ac_neutron_sync'):
        op.create_table(
            'huawei_ac_neutron_sync',
            sa.Column('sync_id', sa.BigInteger, primary_key=True,
                      autoincrement=True),
            sa.Column('sync_start_time', sa.DateTime, default=sa.func.now()),
            sa.Column('expected_completion_time', sa.DateTime,
                      default=sa.func.now(), nullable=True),
            sa.Column('hostname', sa.String(255), nullable=True),
            sa.Column('sync_extension_a', sa.String(255), nullable=True),
            sa.Column('sync_extension_b', sa.String(255), nullable=True),
            sa.Column('sync_extension_c', sa.String(255), nullable=True),
            sa.PrimaryKeyConstraint('sync_id')
        )
