#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: fd3d34c9969e
Revises: f90393fc56f7
Create Date: 2018-05-07 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

# revision identifiers, used by Alembic.
revision = 'fd3d34c9969e'
down_revision = 'f90393fc56f7'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Create table huawei_ac_locked_objects.
    Create table huawei_ac_allocate_vlan.
    """
    if not migration.schema_has_table('huawei_ac_locked_objects'):
        op.create_table(
            'huawei_ac_locked_objects',
            sa.Column('object_uuid', sa.String(36), primary_key=True),
            sa.Column('lock', sa.Boolean, default=False),
            sa.Column('lock_session_id', sa.BigInteger, default=0),
            sa.Column('created_at', sa.DateTime),
        )

    if not migration.schema_has_table('huawei_ac_allocate_vlan'):
        op.create_table(
            'huawei_ac_allocate_vlan',
            sa.Column('id', sa.String(36), primary_key=True),
            sa.Column('cluster_id', sa.String(36), nullable=False),
            sa.Column('network_id', sa.String(36), nullable=False),
            sa.Column('vlan', sa.String(36), nullable=False),
        )
