#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: g0ac3a5de152
Revises: fd3d34c9969e
Create Date: 2018-08-14 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

# revision identifiers, used by Alembic.
revision = 'g0ac3a5de152'
down_revision = 'fd3d34c9969e'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Add column ip_version to table huawei_ac_bgp_route.
    Add column bfd to table huawei_ac_bgp_route.
    Add column session_attribute to table huawei_ac_bgp_route.
    Add column source_ips to table huawei_ac_bgp_route.
    Add column peer_type to table huawei_ac_bgp_route.
    Add column ac_connection_state to table huawei_ac_bgp_route.

    Create table huawei_ac_decrypt_factor.
    """
    if not migration.schema_has_column('huawei_ac_bgp_route', 'ip_version'):
        op.add_column(
            'huawei_ac_bgp_route',
            sa.Column('ip_version', sa.Integer(), nullable=True)
        )

    if not migration.schema_has_column('huawei_ac_bgp_route', 'bfd'):
        op.add_column(
            'huawei_ac_bgp_route',
            sa.Column('bfd', sa.Boolean, nullable=True)
        )

    if not migration.schema_has_column('huawei_ac_bgp_route',
                                       'session_attribute'):
        op.add_column(
            'huawei_ac_bgp_route',
            sa.Column('session_attribute', sa.PickleType, nullable=True)
        )

    if not migration.schema_has_column('huawei_ac_bgp_route', 'source_ips'):
        op.add_column(
            'huawei_ac_bgp_route',
            sa.Column('source_ips', sa.PickleType, nullable=True)
        )

    if not migration.schema_has_column('huawei_ac_bgp_route', 'peer_type'):
        op.add_column(
            'huawei_ac_bgp_route',
            sa.Column('peer_type', sa.Integer(), nullable=True)
        )

    if not migration.schema_has_column('huawei_ac_neutron_state',
                                       'ac_connection_state'):
        op.add_column(
            'huawei_ac_neutron_state',
            sa.Column('ac_connection_state', sa.Integer(), nullable=True)
        )

    if not migration.schema_has_table('huawei_ac_decrypt_factor'):
        op.create_table(
            'huawei_ac_decrypt_factor',
            sa.Column('id', sa.String(36), nullable=True),
            sa.Column('pw_key', sa.String(255), nullable=True),
            sa.Column('pw_iv', sa.String(255), nullable=True),
            sa.Column('key_iv', sa.String(255), nullable=True),
            sa.PrimaryKeyConstraint('id')
        )
