#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: i2549fee8af8
Revises: he28f0c4ab76
Create Date: 2018-09-15 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

# revision identifiers, used by Alembic.
revision = 'i2549fee8af8'
down_revision = 'he28f0c4ab76'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Create table huawei_ac_proc_status.
    """
    if not migration.schema_has_table('huawei_ac_proc_status'):
        op.create_table(
            'huawei_ac_proc_status',
            sa.Column('id', sa.String(36), nullable=True),
            sa.Column('type', sa.String(100), nullable=True),
            sa.Column('ac_proc_status', sa.String(10), nullable=True),
            sa.PrimaryKeyConstraint('id')
        )
