#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: m5c010p0aw5a
Revises: l5c8h23ad17g
Create Date: 2019-05-16 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

revision = 'm5c010p0aw5a'
down_revision = 'l5c8h23ad17g'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Create table huawei_ac_firewall_rule_addrs.
    """
    if not migration.schema_has_table('huawei_ac_firewall_rule_addrs'):
        op.create_table(
            'huawei_ac_firewall_rule_addrs',
            sa.Column('id', sa.String(length=36), nullable=True),
            sa.Column('source_ports', sa.String(length=255), nullable=True),
            sa.Column('destination_ports', sa.String(length=255),
                      nullable=True),
            sa.Column('source_ip_addresses', sa.PickleType, nullable=True),
            sa.Column('destination_ip_addresses', sa.PickleType,
                      nullable=True),
        )
