#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: q3f739v7g3uq
Revises: p1279d19b98d
Create Date: 2019-09-27 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration
from networking_huawei.drivers.ac.db.utcnow import utcnow

revision = 'q3f739v7g3uq'
down_revision = 'p1279d19b98d'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Create table huawei_ac_sync_results.
    Create table huawei_ac_compare_results.
    Add column sync_end_time to table huawei_ac_neutron_sync.
    """
    if not migration.schema_has_table('huawei_ac_sync_results'):
        op.create_table(
            'huawei_ac_sync_results',
            sa.Column('id', sa.String(255), primary_key=True, nullable=False),
            sa.Column('tenant_name', sa.String(255), nullable=True),
            sa.Column('res_name', sa.String(255), nullable=True),
            sa.Column('res_type', sa.String(50), nullable=False),
            sa.Column('create_time', sa.String(50), nullable=True),
            sa.Column('update_time', sa.String(50), nullable=True),
            sa.Column('status', sa.String(50), nullable=False),
            sa.Column('oper', sa.String(50), nullable=False)
        )

    if not migration.schema_has_table('huawei_ac_compare_results'):
        op.create_table(
            'huawei_ac_compare_results',
            sa.Column('id', sa.String(255), primary_key=True, nullable=False),
            sa.Column('tenant_name', sa.String(255), nullable=True),
            sa.Column('res_name', sa.String(255), nullable=True),
            sa.Column('res_type', sa.String(50), nullable=False),
            sa.Column('create_time', sa.String(50), nullable=True),
            sa.Column('update_time', sa.String(50), nullable=True),
            sa.Column('status', sa.String(100), nullable=False)
        )

    if not migration.schema_has_column('huawei_ac_neutron_sync',
                                       'sync_end_time'):
        op.add_column(
            'huawei_ac_neutron_sync',
            sa.Column('sync_end_time', sa.DateTime, default=utcnow())
        )
