#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Huawei AC Mechanism Driver

Revision ID: v1e7rd1gb9gc
Revises: u3fniwe2wevd
Create Date: 2019-09-03 15:38:03.285373

"""

from alembic import op
import sqlalchemy as sa
from neutron.db import migration

revision = 'v1e7rd1gb9gc'
down_revision = 'u3fniwe2wevd'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    Alter column id to String(128) of table huawei_ac_decrypt_factor.
    """
    if migration.schema_has_column('huawei_ac_decrypt_factor', 'id'):
        op.alter_column(
            'huawei_ac_decrypt_factor', 'id',
            type_=sa.String(128),
            nullable=False
        )
