# !/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
"""Huawei AC config

Revision ID: x6ehffeddag5
Revises: x6ehffeddag4
Create Date: 2022-04-08
"""

import sqlalchemy as sa
from alembic import op

from neutron.db import migration
# revision identifiers, used by Alembic.
from oslo_utils import uuidutils

revision = 'x6ehffeddag5'
down_revision = 'x6ehffeddag4'
depends_on = None


def upgrade():
    """Initialize Huawei AC mechanism driver DB.

    表 huawei_ac_basic_config：保存AC配置信息.
    """
    if not migration.schema_has_table('huawei_ac_basic_config'):
        op.create_table(
            'huawei_ac_basic_config',
            sa.Column('id', sa.String(36), primary_key=True, default=uuidutils.generate_uuid),
            sa.Column('config_file', sa.String(255), nullable=False),
            sa.Column('owner', sa.String(128), nullable=False),
            sa.Column('user_group', sa.String(128), nullable=False),
            sa.Column('right', sa.String(10), nullable=False),
            sa.Column('create_time', sa.DateTime, default=sa.func.now()),
            sa.Column('config_value', sa.PickleType, default={}),
            sa.PrimaryKeyConstraint('id')
        )
