#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""utcnow"""

from sqlalchemy.ext.compiler import compiles
from sqlalchemy.types import DateTime
from sqlalchemy.sql import expression


class utcnow(expression.FunctionElement):
    """ utcnow """
    type = DateTime()


@compiles(utcnow, 'postgresql')
def pg_utcnow(element, compiler, **kw):
    """ pg utcnow """
    return "TIMEZONE('utc', CURRENT_TIMESTAMP)"


@compiles(utcnow, 'mysql')
def my_utcnow(element, compiler, **kw):
    """ my utcnow """
    return "UTC_TIMESTAMP()"


@compiles(utcnow, 'mssql')
def ms_utcnow(element, compiler, **kw):
    """ ms utcnow """
    return "GETUTCDATE()"
