#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""ACVpcConnectionSchema class"""

import sqlalchemy as sa

try:
    from neutron.db import model_base
except ImportError:
    from neutron_lib.db import model_base
from oslo_utils import uuidutils


class ACVpcConnectionSchema(model_base.BASEV2):
    """ACVpcConnectionSchema"""
    __tablename__ = 'huawei_ac_vpc_connection'
    id = sa.Column(sa.String(36),
                   primary_key=True,
                   default=uuidutils.generate_uuid)
    tenant_id = sa.Column(sa.String(255), nullable=False)
    name = sa.Column(sa.String(255))
    description = sa.Column(sa.String(255))
    local_router = sa.Column(sa.String(36), nullable=False)
    local_subnets = sa.Column(sa.PickleType(protocol=2), nullable=False)
    local_cidrs = sa.Column(sa.PickleType(protocol=2), nullable=True)
    local_firewall_enable = sa.Column(sa.Boolean, nullable=True)
    peer_router = sa.Column(sa.String(36), nullable=False)
    peer_subnets = sa.Column(sa.PickleType(protocol=2), nullable=False)
    peer_cidrs = sa.Column(sa.PickleType(protocol=2), nullable=True)
    peer_firewall_enable = sa.Column(sa.Boolean, nullable=True)
    status = sa.Column(sa.String(16))
    mode = sa.Column(sa.Integer, default=0, nullable=True)
    priority = sa.Column(sa.Integer, nullable=True)
    fw_enabled = sa.Column(sa.Boolean, nullable=True)
