# !/usr/bin/env python
# -*- coding:utf-8 -*-
"""
| 功能：ac 配置
| 修改记录：2022-03-18 15:01 创建
"""
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

from networking_huawei.drivers.ac.extensions.abstract_neutron_service_extensions import AbstractServiceExt


class Ac_config_ext(AbstractServiceExt):
    """extension of ac config"""

    @property
    def attributes(self):
        """资源字段清单"""
        return {self.get_name(): {
            'id': {
                'allow_post': False, 'allow_put': False,
                'validate': {'type:uuid': None},
                'is_visible': True,
                'primary_key': True
            },
            'config_file': {
                'allow_post': True, 'allow_put': False,
                'validate': {'type:string_or_none': None},
                'is_visible': True
            },
            'owner': {
                'allow_post': False, 'allow_put': False,
                'validate': {'type:string_or_none': None},
                'is_visible': True
            },
            'user_group': {
                'allow_post': True, 'allow_put': False,
                'validate': {'type:string_or_none': None},
                'is_visible': True
            },
            'right': {
                'allow_post': True, 'allow_put': False,
                'validate': {'type:int': None},
                'is_visible': True
            },
            'config_value': {
                'allow_post': True, 'allow_put': False,
                'validate': {'type:dict': {}},
                'is_visible': True
            },
            'create_time': {
                'allow_post': True, 'allow_put': False,
                'validate': {'type:string_or_none': None},
                'is_visible': True
            },
        }}

    def get_alias(self):
        """重载父类名称"""
        return 'ac_config'
