#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""firewall policy status"""

from neutron.db import common_db_mixin
from neutron.api import extensions
try:
    from neutron.api.v2.attributes import ATTR_NOT_SPECIFIED
except ImportError:
    from neutron_lib.constants import ATTR_NOT_SPECIFIED
try:
    from neutron.api.extensions import ExtensionDescriptor
except ImportError:
    from neutron_lib.api.extensions import ExtensionDescriptor
from networking_huawei._i18n import _LI
from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_ml2_api as api
from networking_huawei.drivers.ac.extensions import firewallpolicystatus
from networking_huawei.drivers.ac.common import neutron_compatible_util as ncu

extensions.append_api_extensions_path(firewallpolicystatus.__path__)
LOG = logging.getLogger(__name__)

AC_PROCESS_STATE = 'ac_process_state'
DESCRIPTION = 'extend ac process status for firewall'

EXTENDED_ATTRIBUTES_2_0 = {
    'firewall_policies': {
        AC_PROCESS_STATE: {'allow_post': False, 'allow_put': False,
                           'default': ATTR_NOT_SPECIFIED,
                           'enforce_policy': True,
                           'is_visible': True},
    },
    'firewall_rules': {
        AC_PROCESS_STATE: {'allow_post': False, 'allow_put': False,
                           'default': ATTR_NOT_SPECIFIED,
                           'enforce_policy': True,
                           'is_visible': True},
    }
}


class Firewallpolicystatus(ExtensionDescriptor):
    """Firewall policy status"""
    @classmethod
    def get_name(cls):
        """get_name"""
        return "ac_process_state"

    @classmethod
    def get_alias(cls):
        """get_alias"""
        return "ac_process_state"

    @classmethod
    def get_description(cls):
        """get_description"""
        return "extend ac firewall policy status for port"

    @classmethod
    def get_namespace(cls):
        """get_namespace"""
        return ''

    @classmethod
    def get_updated(cls):
        """get_updated"""
        return '2018-09-01T12:00:00-00:00'

    def get_extended_resources(self, version):
        """get_extended_resources"""
        if version == "2.0":
            return EXTENDED_ATTRIBUTES_2_0
        return {}


class FwpolicystatusExtensionDriver(api.ExtensionDriver,
                                    common_db_mixin.CommonDbMixin):
    """Fw policy status Extension Driver"""
    _supported_extension_alias = AC_PROCESS_STATE

    def initialize(self):
        """initialize"""
        self.ops_version = ncu.get_ops_version()
        LOG.info(_LI('[AC][FwpolicystatusExtensionDriver] '
                     'initialization complete'))

    @property
    def extension_alias(self):
        """extension_alias"""
        return self._supported_extension_alias
