#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""port status"""

import json
from oslo_config import cfg
try:
    from neutron.db import common_db_mixin
except ImportError:
    from networking_huawei.drivers.ac.common import common_db_mixin
from neutron.db import models_v2
from neutron.plugins.ml2 import models
from neutron.api import extensions
try:
    from neutron.api.v2.attributes import ATTR_NOT_SPECIFIED
except ImportError:
    from neutron_lib.constants import ATTR_NOT_SPECIFIED
try:
    from neutron.api.extensions import ExtensionDescriptor
except ImportError:
    from neutron_lib.api.extensions import ExtensionDescriptor
from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_ml2_api as api
from networking_huawei._i18n import _LI
from networking_huawei.drivers.ac.common import constants as ac_constants
from networking_huawei.drivers.ac.extensions import portstatus
from networking_huawei.drivers.ac.db.ac_proc_status import schema \
    as ac_proc_status_schema
from networking_huawei.drivers.ac.db.ac_proc_status.ac_proc_status_db import \
    ACProStatusDbMixin
from networking_huawei.drivers.ac.common  import neutron_compatible_util as ncu
extensions.append_api_extensions_path(portstatus.__path__)
LOG = ncu.ac_log.getLogger(__name__)

AC_PROCESS_STATE_PORT = 'ac_process_state'
DESCRIPTION = 'extend ac process status for port'

EXTENDED_ATTRIBUTES_2_0 = {
    'ports': {
        AC_PROCESS_STATE_PORT: {'allow_post': False, 'allow_put': False,
                                'default': ATTR_NOT_SPECIFIED,
                                'enforce_policy': True,
                                'is_visible': True},
    }
}


class Portstatus(ExtensionDescriptor):
    """Port status"""
    @classmethod
    def get_name(cls):
        """get name"""
        return AC_PROCESS_STATE_PORT

    @classmethod
    def get_alias(cls):
        """get alias"""
        return AC_PROCESS_STATE_PORT

    @classmethod
    def get_namespace(cls):
        """get namespace"""
        return ''

    @classmethod
    def get_description(cls):
        """get description"""
        return DESCRIPTION

    @classmethod
    def get_updated(cls):
        """get updated"""
        return '2018-09-01T12:00:00-00:00'

    @classmethod
    def get_extended_resources(cls, version):
        """get extended resources for controller"""
        if version == "2.0":
            return EXTENDED_ATTRIBUTES_2_0
        return {}


class PortACProcStatusExtensionDriver(api.ExtensionDriver,
                                      common_db_mixin.CommonDbMixin):
    """PortBinding Extension Driver"""
    _supported_extension_alias = AC_PROCESS_STATE_PORT

    def initialize(self):
        """initialize"""
        self.ops_version = ncu.get_ops_version()
        LOG.info(_LI('[AC][PortACProcStatusExtensionDriver] '
                     'initialization complete'))

    @property
    def extension_alias(self):
        """extension alias"""
        return self._supported_extension_alias

    def extend_port_dict(self, session, db_data, result):
        """extend port dict"""
        ac_proc_status = ''
        ac_proc_status_list = None
        with session.begin(subtransactions=True):
            if (ncu.IS_FSP and ac_constants.NW_HW_AC_STATUS_PORT in
                    cfg.CONF.ml2.extension_drivers):
                LOG.info(_LI('[AC][PortACProcStatusExtensionDriver]'
                             'need to read status'))
                port_rec = session.query(models_v2.Port). \
                    filter_by(id=db_data['id']).all()
                # for the scenes: create fail, rollback to delete and fail
                port_bindings = session.query(models.PortBinding). \
                    filter_by(port_id=db_data['id']).all()
                if port_bindings and port_bindings[0].profile and json.loads(
                        port_bindings[0].profile). \
                        get('sdn_binding_status') == 'failed':
                    device_info = {
                        'id': db_data['id'],
                        'type': 'port',
                        'ac_proc_status': ac_constants.NEUTRON_STATUS_ERROR
                    }
                    ac_proc_func = ACProStatusDbMixin()
                    ac_proc_func.update_db_ac_proc_status(device_info)
                    LOG.info(_LI('[AC]update ac proc status from '
                                 'extension. res:%s, status:%s'), db_data['id'],
                             port_rec[0].status)
                elif port_rec and port_rec[0].status in \
                        [ac_constants.NEUTRON_STATUS_ACTIVE,
                         ac_constants.NEUTRON_STATUS_ERROR]:
                    device_info = {
                        'id': db_data['id'],
                        'type': 'port',
                        'ac_proc_status': port_rec[0].status
                    }
                    ac_proc_func = ACProStatusDbMixin()
                    ac_proc_func.update_db_ac_proc_status(device_info)
                    LOG.info(_LI('[AC]update ac proc status from '
                                 'extension. res:%s, status:%s'), db_data['id'],
                             port_rec[0].status)
                ac_proc_status_list = session.query(
                    ac_proc_status_schema.ACProcStatusSchema).filter_by(
                        id=db_data['id']).all()
                if ac_proc_status_list:
                    ac_proc_status = ac_proc_status_list[0].ac_proc_status
                    LOG.info(_LI('[AC][PortACProcStatusExtensionDriver]'
                                 'read ac_proc_staus: %s'), ac_proc_status)
                else:
                    LOG.info(_LI('[AC][PortACProcStatusExtensionDriver]'
                                 'no record-ac_proc_status in db'))
            result['ac_process_state'] = ac_proc_status
