#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""external policy model"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)


class ACExternalPolicyModel(object):
    """ACExternalPolicyModel"""
    @staticmethod
    def ac_model_format(external_policy):
        """ac_model_format"""
        try:
            external_policy_info = {
                'uuid': external_policy['id'],
                'name': external_policy['name'],
                'tenant-id': external_policy['tenant_id'],
                'descr': external_policy['description'],
                'external-segments': external_policy['external_segments'],
                'consumer-rule-set':
                    external_policy['consumed_policy_rule_sets'],
                'provider-rule-set':
                    external_policy['provided_policy_rule_sets'],
                'shared': external_policy['shared'],
            }
        except KeyError as value:
            LOG.error(_LE("[AC]Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError

        return external_policy_info
