#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""external segment model"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LE
from networking_huawei.drivers.ac.common import constants as ac_const

LOG = logging.getLogger(__name__)


class ACExternalSegmentModel(object):
    """ACExternalSegmentModel"""
    @staticmethod
    def ac_model_format(external_segment):
        """ac_model_format"""
        try:
            external_segment_info = {
                'uuid': external_segment['id'],
                'name': external_segment['name'],
                'tenant-id': external_segment['tenant_id'],
                'descr': external_segment['description'],
                'subnet-id': external_segment['subnet_id'],
                'cidr': external_segment['cidr'],
                'external-routes': external_segment['external_routes'],
                'port-address-translation':
                    external_segment['port_address_translation'],
                'shared': external_segment['shared'],
            }
            if 'ip_version' in external_segment:
                external_segment_info['ip-version'] = \
                    ac_const.NEUTRON_CONSTANTS + 'ip-version-v' + \
                    str(external_segment['ip_version'])
        except KeyError as value:
            LOG.error(_LE("[AC]Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError

        return external_segment_info
