#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""firewall policy model"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)


class ACFirewallPolicyModel(object):
    """ACFirewallPolicyModel"""

    @staticmethod
    def ac_model_format(firewall_policy):
        """Convert data to AC model"""
        try:
            fw_policy_info = {
                'name': firewall_policy['name'],
                'tenant-id': firewall_policy['tenant_id']
            }

            if firewall_policy.get('id') is not None:
                fw_policy_info['uuid'] = firewall_policy['id']

            if firewall_policy.get('description') is not None:
                fw_policy_info['descr'] = firewall_policy['description']

            if firewall_policy.get('shared') is not None:
                fw_policy_info['shared'] = firewall_policy['shared']

            if firewall_policy.get('firewall_rules') is not None:
                fw_policy_info['firewall-rules'] = \
                    firewall_policy['firewall_rules']

            if firewall_policy.get('audited') is not None:
                fw_policy_info['audited'] = firewall_policy['audited']

        except KeyError as value:
            LOG.error(_LE("[AC]Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError

        return fw_policy_info

    @staticmethod
    def ac_model_format_act_rule(obj_info):
        """Convert data to AC model"""
        try:
            act_rule_info = {
                'id': obj_info['id'],
                'firewall_rule_id': obj_info['firewallRuleId'],
                'insert_before': obj_info.get('insertBefore', ''),
                'insert_after': obj_info.get('insertAfter', '')
            }
            if not act_rule_info['insert_before']:
                act_rule_info.pop('insert_before')
            if not act_rule_info['insert_after']:
                act_rule_info.pop('insert_after')

        except KeyError as value:
            LOG.error(_LE("[AC]Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError

        return act_rule_info
