#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""Floating IP model."""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)


class ACFloatingipModel(object):
    """Floating IP model."""
    @staticmethod
    def ac_model_format(floatingip):
        """Convert floating IP data to AC model."""
        try:
            floatingip_info = {
                'uuid': floatingip['id'],
                'tenant-id': floatingip['tenant_id'],
                'floating-ip-address': floatingip['floating_ip_address'],
                'floating-network-id': floatingip['floating_network_id'],
                'port-id': floatingip['port_id'],
                'fixed-ip-address': floatingip['fixed_ip_address']
            }
            if floatingip.get('router_id'):
                floatingip_info['router-id'] = floatingip['router_id']
            if floatingip.get('created_at'):
                floatingip_info['created-at'] = floatingip['created_at']
            if floatingip.get('updated_at'):
                floatingip_info['updated-at'] = floatingip['updated_at']
            if floatingip.get('qos_policy_id'):
                floatingip_info['qos-policy-id'] = floatingip['qos_policy_id']
        except KeyError as value:
            LOG.error(_LE("[AC]Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError

        return floatingip_info
