#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""policy classifier model"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)
GBP_CLASSIFY_PROTOCOL_ANY = 0

class ACPolicyClassifierModel(object):
    """ACPolicyClassifierModel"""

    @staticmethod
    def ac_model_format(policy_classifier, tenant_name):
        """Convert data to AC model"""
        try:

            policy_classifier_to_ac = {
                'name': policy_classifier['name'],
                'tenant-id': policy_classifier['tenant_id'],
                'tenant-name': tenant_name
            }

            if policy_classifier.get('id') is not None:
                policy_classifier_to_ac['uuid'] = policy_classifier['id']

            if policy_classifier.get('description') is not None:
                policy_classifier_to_ac['descr'] = \
                    policy_classifier['description']

            if policy_classifier.get('shared') is not None:
                policy_classifier_to_ac['shared'] = \
                    policy_classifier['shared']

            ACPolicyClassifierModel.\
                get_policy_port_range(policy_classifier,
                                      policy_classifier_to_ac)

            if policy_classifier.get('direction') is not None:
                policy_classifier_to_ac['direction'] = \
                    policy_classifier['direction']

            ACPolicyClassifierModel.\
                get_policy_protocol(policy_classifier, policy_classifier_to_ac)

        except KeyError as value:
            LOG.error(_LE("[AC]Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError

        return policy_classifier_to_ac

    @staticmethod
    def get_policy_port_range(policy_classifier, policy_classifier_to_ac):
        """get_policy_port_range"""
        if policy_classifier.get('port_range') is not None:
            if policy_classifier['port_range'].find(':') != -1:
                split_range = policy_classifier['port_range'].split(":")
                policy_classifier_to_ac['port-range-min'] = split_range[0]
                policy_classifier_to_ac['port-range-max'] = split_range[1]
            else:
                policy_classifier_to_ac['port-range-min'] = \
                    policy_classifier['port_range']
                policy_classifier_to_ac['port-range-max'] = \
                    policy_classifier['port_range']

    @staticmethod
    def get_policy_protocol(policy_classifier, policy_classifier_to_ac):
        """get_policy_protocol"""
        if 'protocol' in policy_classifier:
            if policy_classifier['protocol'] is not None:
                policy_classifier_to_ac['protocol'] = \
                    policy_classifier['protocol']
            else:
                policy_classifier_to_ac['protocol'] = \
                    str(GBP_CLASSIFY_PROTOCOL_ANY)
