#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2016 Huawei Technologies Co. Ltd. All rights reserved.
"""snat model"""

from networking_huawei.drivers.ac.common.neutron_compatible_util import \
    ac_log as logging
from networking_huawei._i18n import _LE

LOG = logging.getLogger(__name__)


class ACSNATModel(object):
    """ACSNATModel"""

    @staticmethod
    def ac_model_format(floatingip, snat_cidrs):
        """Convert data to AC model"""
        try:
            snat_info = {
                'uuid': floatingip['id'],
                'router-id': floatingip['router_id'],
                'tenant-id': floatingip['tenant_id'],
                'snat-network-id': floatingip['floating_network_id'],
                'snat-ip-address': floatingip['floating_ip_address'],
                'orignal-cidrs': snat_cidrs
            }
            if floatingip.get('name'):
                snat_info['name'] = floatingip['name']
            if floatingip.get('created_at'):
                snat_info['created-at'] = floatingip['created_at']
            if floatingip.get('updated_at'):
                snat_info['updated-at'] = floatingip['updated_at']
        except KeyError as value:
            LOG.error(_LE("[AC] Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError

        return snat_info

    @staticmethod
    def ac_model_format_v2(snat):
        """ac_model_format_v2"""
        try:
            snat_info = {
                'uuid': snat['id'],
                'tenant-id': snat['tenant_id'],
                'router-id': snat['router_id'],
                'snat-network-id': snat['snat_network_id'],
                'type': snat['type'],
            }
            if snat.get('name'):
                snat_info['name'] = snat['name']
            if snat.get('snat_ip_address'):
                snat_info['snat-ip-address'] = snat['snat_ip_address']
            if snat.get('snat_ip_pool'):
                snat_info['snat-ip-pool'] = []
                for pool in snat['snat_ip_pool']:
                    snat_info['snat-ip-pool'].append({
                        'begin-ip': pool['begin_ip'],
                        'end-ip': pool['end_ip']
                    })
            if snat.get('original_cidrs'):
                snat_info['orignal-cidrs'] = snat['original_cidrs']
        except KeyError as value:
            LOG.error(_LE("[AC] Key Error, doesn't contain all fields %s."),
                      value)
            raise KeyError

        return snat_info
