import contextlib


@contextlib.contextmanager
def autonested_transaction(session):
    if session.is_active:
        session_context = session.begin(nested=True)
    else:
        session_context = session.begin(subtransactions=True)
    with session_context as tx:
        yield tx