#!/bin/bash

PYTHON_SITE_PATH=$(python -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")

BAK_VERSION=$1

INSTALL_PATH=/root/networking-huawei
EGG_VERSION=$(grep '^Version' $INSTALL_PATH/PKG-INFO | awk '{print $2}')
PYTHON_VERSION=$(python -c "import sys; print ('py%s.%s' % (sys.version_info.major, sys.version_info.minor))")
NETWORKING_HUAWEI_EGG=$PYTHON_SITE_PATH/networking_huawei-$EGG_VERSION-$PYTHON_VERSION.egg-info
NETWORKING_HUAWEI_EGG_BAK=$PYTHON_SITE_PATH/networking_huawei-$EGG_VERSION-$PYTHON_VERSION.egg-info.$BAK_VERSION

PlUGIN_VERSIONS=(
"v1r21c00"
)

if [[ -z ${BAK_VERSION} ]] || [[ ! ${PlUGIN_VERSIONS[@]} =~ $BAK_VERSION ]]; then
    echo "Please input a correct plugin version in: [${PlUGIN_VERSIONS[@]}]"
    exit 1
fi

echo "****Begin to backup config****"
rm -f /etc/neutron/huawei_driver_config.ini.$BAK_VERSION
cp -af /etc/neutron/huawei_driver_config.ini /etc/neutron/huawei_driver_config.ini.$BAK_VERSION
echo "copy /etc/neutron/huawei_driver_config.ini to /etc/neutron/huawei_driver_config.ini."${BAK_VERSION}

rm -f /etc/neutron/neutron.conf.$BAK_VERSION
cp -af /etc/neutron/neutron.conf /etc/neutron/neutron.conf.$BAK_VERSION
echo "copy /etc/neutron/neutron.conf to /etc/neutron/neutron.conf."${BAK_VERSION}

rm -f /etc/neutron/plugins/ml2/ml2_conf.ini.$BAK_VERSION
cp -af /etc/neutron/plugins/ml2/ml2_conf.ini /etc/neutron/plugins/ml2/ml2_conf.ini.$BAK_VERSION
echo "copy /etc/neutron/plugins/ml2/ml2_conf.ini to /etc/neutron/plugins/ml2/ml2_conf.ini."${BAK_VERSION}

rm -f /etc/neutron/whitelist.ini.$BAK_VERSION
cp -af /etc/neutron/whitelist.ini /etc/neutron/whitelist.ini.$BAK_VERSION
echo "copy /etc/neutron/whitelist.ini to /etc/neutron/whitelist.ini."${BAK_VERSION}

rm -rf $PYTHON_SITE_PATH/networking_huawei.$BAK_VERSION
cp -af $PYTHON_SITE_PATH/networking_huawei $PYTHON_SITE_PATH/networking_huawei.$BAK_VERSION
echo "copy "${PYTHON_SITE_PATH}"/networking_huawei to "${PYTHON_SITE_PATH}"/networking_huawei.$BAK_VERSION"

rm -rf $NETWORKING_HUAWEI_EGG_BAK
cp -af $NETWORKING_HUAWEI_EGG $NETWORKING_HUAWEI_EGG_BAK
echo "copy "${NETWORKING_HUAWEI_EGG}" to "${NETWORKING_HUAWEI_EGG_BAK}
echo "****End to backup config****"
echo ""

echo "****Begin to backup networking_huawei****"
rm -rf /root/networking-huawei_$BAK_VERSION
cp -af /root/networking-huawei /root/networking-huawei_$BAK_VERSION
echo "copy /root/networking-huawei to /root/networking-huawei_"$BAK_VERSION
if [ -e /root/networking-huawei.tar.gz ]; then
    rm -f /root/networking-huawei.tar.gz.$BAK_VERSION
    cp -af /root/networking-huawei.tar.gz /root/networking-huawei.tar.gz.$BAK_VERSION
    echo "copy /root/networking-huawei.tar.gz to /root/networking-huawei.tar.gz."$BAK_VERSION
fi
echo "****End to backup networking_huawei****"
echo ""

ops_version=$(grep ^OPS_version /etc/neutron/huawei_driver_config.ini.$BAK_VERSION)
fps_prc_bak=$PYTHON_SITE_PATH/neutron/plugins/ml2/rpc.py.bak_by_ac
if [[ $ops_version =~ "FusionSphere" ]] && [[ -e FSP_RPC_BAK ]]; then
  echo "****Begin to backup rpc.py.bak_by_ac****"
  rm -f /home/fsp/rpc.py.bak_by_ac
  cp $fps_prc_bak /home/fsp/rpc.py.bak_by_ac
  echo "copy "${fps_prc_bak}" to /home/fsp/rpc.py.bak_by_ac"
  echo "****End to backup rpc.py.bak_by_ac****"
fi

driver_version="c4818a243f6f"
db_parent_path=$PYTHON_SITE_PATH/neutron/db/migration/alembic_migrations/versions
driver_py=${db_parent_path}/${driver_version}_huawei_ac_mechanisam_driver.py

if [[ -e ${driver_py} ]] && [[ $ops_version =~ "Kilo" ]]; then
  echo "****Begin to backup"${driver_py}"****"
  rm -f $driver_py.$BAK_VERSION
  cp $driver_py $driver_py.$BAK_VERSION
  echo "copy "${driver_py}" to "$driver_py.$BAK_VERSION
  echo "****End to backup "${driver_py}"****"
fi