#!/bin/bash
TIME=`date "+%Y-%m-%d-%H-%M-%S"`
BASE_PATH=$(cd `dirname $0`; cd ..; pwd)
HUAWEI_DRIVER_BASE=$BASE_PATH/etc/oslo-config-generator/huawei_driver.ini
HUAWEI_DRIVER_INI=/etc/neutron/huawei_driver_config.ini
HUAWEI_DRIVER_CONF=/usr/share/neutron/server/huawei_driver_config.conf
HUAWEI_DRIVER_CPIC=/root/huawei-tools/networking_huawei_config.txt
WHITE_LIST_INI=/etc/neutron/whitelist.ini
NEUTRON_CONF=/etc/neutron/neutron.conf
ML2_CONF_INI=/etc/neutron/plugins/ml2/ml2_conf.ini
PYTHON_PATH=$(python -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")
HUAWEI_EXTENSIONS_PATH=$PYTHON_PATH/networking_huawei/drivers/ac/extensions

ENABLE_ROUTER=1
ENABLE_SYNC=1
ENABLE_QOS=1
ENABLE_FWAAS=1
ENABLE_VPNAAS=1
ENABLE_DNAT=1

function change_mode_and_owner() {
    if [ -d $1 ]; then
        for file in `ls $1`
        do
            if [ -d $1"/"$file ]; then
                change_mode_and_owner $1"/"$file $2
            else
                chmod $2 $1"/"$file
                chown neutron:neutron $1"/"$file
            fi
        done
    else
        chmod $2 $1
        chown neutron:neutron $1
    fi
}

function get_config_params() {
    params_arr=()
    while read line; do
        if [[ "$line" =~ "=" && ! "$line" =~ ^# ]]; then
            param=`echo $line | cut -d "=" -f 1 | sed s/[[:space:]]//g`
            params_arr=(${params_arr[*]} $param)
        fi
    done < $1
}

function config_generate() {
    oslo-config-generator --config-file $HUAWEI_DRIVER_BASE > /dev/null 2>&1
    mv $BASE_PATH/etc/huawei_driver_config.ini.sample $HUAWEI_DRIVER_INI
    sed -i '/^#.*value)$/d' $HUAWEI_DRIVER_INI
    sed -i '/^# From networking_huawei.ac_config/d' $HUAWEI_DRIVER_INI
    sed -i '/^#$/d' $HUAWEI_DRIVER_INI
    chmod 600 $HUAWEI_DRIVER_INI
    chown neutron:neutron $HUAWEI_DRIVER_INI
    cp -f $BASE_PATH/tools/whitelist_sample.ini $WHITE_LIST_INI
    chmod 600 $WHITE_LIST_INI
    chown neutron:neutron $WHITE_LIST_INI
    rm -rf $HUAWEI_DRIVER_CONF
    ln -s $HUAWEI_DRIVER_INI $HUAWEI_DRIVER_CONF
}

function neutron_config() {
    cp -af $ML2_CONF_INI $ML2_CONF_INI.$TIME
    mechanism_drivers=`grep ^mechanism_drivers $ML2_CONF_INI | cut -d "=" -f 2 | sed s/[[:space:]]//g`
    if [[ -n "$mechanism_drivers" ]]; then
        if [[ ! $mechanism_drivers =~ huawei_ac_ml2 ]]; then
            sed -i "s/^mechanism_drivers.*/mechanism_drivers = huawei_ac_ml2,$mechanism_drivers/" $ML2_CONF_INI
        fi
    else
        sed -i "/^\[ml2\]/a\mechanism_drivers = huawei_ac_ml2,openvswitch" $ML2_CONF_INI
    fi

    cp -af $NEUTRON_CONF $NEUTRON_CONF.$TIME
    service_plugins=`grep ^service_plugins $NEUTRON_CONF | cut -d "=" -f 2 | sed s/[[:space:]]//g`
    api_extensions_path=`grep ^api_extensions_path $NEUTRON_CONF | cut -d "=" -f 2 | sed s/[[:space:]]//g`

    if [[ -n "$service_plugins" ]]; then
        plugins=`echo $service_plugins`
        for plugin in ${plugins//,/ }; do
            if [[ "$plugin" == "router" ]]; then
                service_plugins=`echo $service_plugins | sed 's/router,//g' | sed 's/,router//g' | sed 's/router//g'`
            fi
            if [[ "$plugin" == "qos" && $ENABLE_QOS -eq 1 ]]; then
                service_plugins=`echo $service_plugins | sed 's/qos,//g' | sed 's/,qos//g' | sed 's/qos//g'`
            fi
            if [[ $plugin =~ firewall && $ENABLE_FWAAS -eq 1 ]]; then
                service_plugins=`echo $service_plugins | sed 's/'"$plugin"',//g' | sed 's/,'"$plugin"'//g' | sed 's/'"$plugin"'//g'`
            fi
            if [[ $plugin =~ vpnaas && $ENABLE_VPNAAS -eq 1 ]]; then
                service_plugins=`echo $service_plugins | sed 's/'"$plugin"',//g' | sed 's/,'"$plugin"'//g' | sed 's/'"$plugin"'//g'`
            fi
        done
    fi

    if [ $ENABLE_ROUTER -eq 1 ]; then
        if [[ ! $service_plugins =~ huawei_ac_router ]]; then
            if [[ -z "$service_plugins" ]]; then
                service_plugins="huawei_ac_router"
            else
                service_plugins=$service_plugins",huawei_ac_router"
            fi
        fi
        if [[ ! $api_extensions_path =~ ac/extensions/exroute ]]; then
            if [[ -z "$api_extensions_path" ]]; then
                api_extensions_path="$HUAWEI_EXTENSIONS_PATH/exroute"
            else
                api_extensions_path=$api_extensions_path":$HUAWEI_EXTENSIONS_PATH/exroute"
            fi
        fi
    fi

    if [ $ENABLE_SYNC -eq 1 ]; then
        if [[ ! $service_plugins =~ huawei_ac_ext ]]; then
            service_plugins=$service_plugins",huawei_ac_ext"
        fi
        if [[ ! $api_extensions_path =~ ac/extensions/sync ]]; then
            api_extensions_path=$api_extensions_path":$HUAWEI_EXTENSIONS_PATH/sync"
        fi
    fi

    if [ $ENABLE_QOS -eq 1 ]; then
        if [[ ! $service_plugins =~ huawei_ac_qos ]]; then
            service_plugins=$service_plugins",huawei_ac_qos"
        fi
        if [[ -n `grep "^\[qos\]" $NEUTRON_CONF` ]]; then
            notification_drivers=`grep ^notification_drivers $NEUTRON_CONF | cut -d "=" -f 2 | sed s/[[:space:]]//g`
            if [[ -n "$notification_drivers" ]]; then
                if [[ ! $notification_drivers =~ huawei_ac_qos_driver ]]; then
                    sed -i "s/^notification_drivers.*/notification_drivers = huawei_ac_qos_driver,$notification_drivers/g" $NEUTRON_CONF
                fi
            else
                sed -i "/^\[qos\]/a\notification_drivers = huawei_ac_qos_driver,message_queue" $NEUTRON_CONF
            fi
        else
            echo -e "\n[qos]" >> $NEUTRON_CONF
            echo -e "notification_drivers = huawei_ac_qos_driver,message_queue" >> $NEUTRON_CONF
        fi
        extension_drivers=`grep ^extension_drivers $ML2_CONF_INI | cut -d "=" -f 2 | sed s/[[:space:]]//g`
        if [[ -n "$extension_drivers" ]]; then
            if [[ ! $extension_drivers =~ qos ]]; then
                sed -i "s/^extension_drivers.*/extension_drivers = qos,$extension_drivers/g" $ML2_CONF_INI
            fi
        else
            sed -i "/^\[ml2\]/a\extension_drivers = qos" $ML2_CONF_INI
        fi
    fi

    if [ $ENABLE_FWAAS -eq 1 ]; then
        if [[ ! $service_plugins =~ huawei_ac_fwaas ]]; then
            service_plugins=$service_plugins",huawei_ac_fwaas"
        fi
        if [[ ! $api_extensions_path =~ neutron_fwaas/extensions ]]; then
            api_extensions_path=$api_extensions_path":$PYTHON_PATH/neutron_fwaas/extensions"
        fi
    fi

    if [ $ENABLE_VPNAAS -eq 1 ]; then
        if [[ ! $service_plugins =~ huawei_ac_ipsecvpn ]]; then
            service_plugins=$service_plugins",huawei_ac_ipsecvpn"
        fi
        if [[ ! $api_extensions_path =~ neutron_vpnaas/extensions ]]; then
            api_extensions_path=$api_extensions_path":$PYTHON_PATH/neutron_vpnaas/extensions"
        fi
    fi

    if [ $ENABLE_DNAT -eq 1 ]; then
        if [[ $service_plugins =~ huawei_ac_dnat ]]; then
            service_plugins=$service_plugins",huawei_ac_dnat"
        fi
    fi

    if [[ -n `grep ^service_plugins $NEUTRON_CONF` ]]; then
        sed -i "s#^service_plugins.*#service_plugins = $service_plugins#g" $NEUTRON_CONF
    else
        sed -i "/^\[DEFAULT\]/a\service_plugins = $service_plugins" $NEUTRON_CONF
    fi

    if [[ -n `grep ^api_extensions_path $NEUTRON_CONF` ]]; then
        sed -i "s#^api_extensions_path.*#api_extensions_path = $api_extensions_path#g" $NEUTRON_CONF
    else
        sed -i "/^service_plugins/a\api_extensions_path = $api_extensions_path" $NEUTRON_CONF
    fi
}

function neutron_db_upgrade() {
    neutron-db-manage --subproject networking-huawei upgrade head
}

if [[ "$1" == "chmod" ]]; then
    if [[ -e $2 && $3 =~ ^[0-9]{3} ]]; then
        change_mode_and_owner $2 $3
    fi

elif [[ "$1" == "python_path" ]]; then
    echo $PYTHON_PATH

elif [[ "$1" == "python_version" ]]; then
    python -c "import sys; print ('py%s.%s' % (sys.version_info.major, sys.version_info.minor))"

elif [[ "$1" == "uninstall" ]]; then
    rm -rf $PYTHON_PATH/networking_huawei*

elif [[ "$1" == "config_generate" ]]; then
    config_generate

elif [[ "$1" == "driver_config" ]]; then
    get_config_params $2
    for param in ${params_arr[@]}; do
        value=`grep ^$param $2 | cut -d "=" -f 1 --complement | sed s/^[[:space:]]// | sed s/[[:space:]]$//`
        if [[ -n "$value" ]]; then
            if [[ "$param" == "ac_auth_password" ]]; then
                pwd=`python $BASE_PATH/tools/encryptor.py "$value" 1`
                sed -i "s%[#]*$param.*%$param = $pwd%g" $HUAWEI_DRIVER_INI
            elif [[ "$param" == "keystone_passwd" ]]; then
                pwd=`python $BASE_PATH/tools/encryptor.py "$value" 2`
                sed -i "s%[#]*$param.*%$param = $pwd%g" $HUAWEI_DRIVER_INI
            elif [[ "$param" == "websocket_key_password" ]]; then
                pwd=`python $BASE_PATH/tools/encryptor.py "$value" 3`
                sed -i "s%[#]*$param.*%$param = $pwd%g" $HUAWEI_DRIVER_INI
            else
                sed -i "s%[#]*$param.*%$param = $value%g" $HUAWEI_DRIVER_INI
            fi
        fi
    done

elif [[ "$1" == "neutron_config" ]]; then
    if [[ "$3" == "CPIC" ]]; then
        if [[ ! `grep service_plugins $2 | grep huawei_ac_router` ]]; then
            ENABLE_ROUTER=0
        fi
        if [[ ! `grep service_plugins $2 | grep huawei_ac_ext` ]]; then
            ENABLE_SYNC=0
        fi
        if [[ ! `grep service_plugins $2 | grep huawei_ac_qos` ]]; then
            ENABLE_QOS=0
        fi
        if [[ ! `grep service_plugins $2 | grep huawei_ac_fwaas` ]]; then
            ENABLE_FWAAS=0
        fi
        if [[ ! `grep service_plugins $2 | grep huawei_ac_ipsecvpn` ]]; then
            ENABLE_VPNAAS=0
        fi
        if [[ ! `grep service_plugins $2 | grep huawei_ac_dnat` ]]; then
            ENABLE_DNAT=0
        fi
    else
        if [[ ! `grep ^enable_qos $2 | cut -d "=" -f 2 | sed s/[[:space:]]//g` =~ ^[Tt]rue$ ]]; then
            ENABLE_QOS=0
        fi
        if [[ ! `grep ^enable_fwaas $2 | cut -d "=" -f 2 | sed s/[[:space:]]//g` =~ ^[Tt]rue$ ]]; then
            ENABLE_FWAAS=0
        fi
        if [[ ! `grep ^enable_vpnaas $2 | cut -d "=" -f 2 | sed s/[[:space:]]//g` =~ ^[Tt]rue$ ]]; then
            ENABLE_VPNAAS=0
        fi
        if [[ ! `grep ^enable_dnat $2 | cut -d "=" -f 2 | sed s/[[:space:]]//g` =~ ^[Tt]rue$ ]]; then
            ENABLE_DNAT=0
        fi
    fi

    neutron_config
    neutron_db_upgrade

elif [[ "$1" == "host_ip" ]]; then
    host_ip=`ifconfig | grep -w inet | grep -v 127.0.0.1 | awk '{print $2}' | sed s/[[:space:]]//g`
    sed -i "s%[#]*host_ip.*%host_ip = $host_ip%g" $HUAWEI_DRIVER_INI
fi
