#!/bin/sh

ZK_SERVICE_CACHE_PARSER_FILE='/usr/bin/install_tool/zk_cache_cfg_parser.py'
dc_admin_name=`python $ZK_SERVICE_CACHE_PARSER_FILE -s cps -t cps-web -c dc_admin_name`

function get_char(){
    stty cbreak -echo
    dd if=/dev/tty bs=1 count=1 2>/dev/null
    stty -cbreak echo
}

if [ -z $1 ]; then
    echo -e "+ Please input ${dc_admin_name}_admin password: \c"
    while :; do
        ret=`get_char`
        if [ x$ret = x ]; then
            echo
            break
        fi
        password="$password$ret"
    done
else
    password=$1
fi

source set_env << EOF > /dev/null
1
$password
EOF

cps template-instance-list --service neutron neutron-server |grep `cat /etc/uuid`> /dev/null 2>&1
if [ $? -ne 0 ]; then
    exit 1
fi

while true
    do
        if [ -z $1 ]; then
            read -p '+ Please make a choice: [Y|N] ' choice
        else
            choice=Y
        fi
        if [ "$choice" == "Y" -o "$choice" == "y" ]; then
            sleep 1
            #service_plugins
            echo -e '+ Begin to uninstall agile-controller:'
            echo -e '1. uninstall service_plugins...'

            PLUGIN_PATH=networking_huawei.drivers.ac.plugins
            L3_PLUGINS=$PLUGIN_PATH.l3.ac_l3_router_plugin.HuaweiACL3RouterPlugin
            FWAAS_PLUGINS=$PLUGIN_PATH.fwaas.fwaas_plugin.HuaweiACFwaasPlugin
            VPNAAS_PLUGINS=$PLUGIN_PATH.vpnaas.vpnaas_plugin.HuaweiIPsecVPNPlugin
            current_service_plugins=`sed '/^service_plugins =/!d;s/.*=//' /etc/neutron/neutron.conf`
            original_service_plugins=""
            new_service_plugins=""
            if [[ $current_service_plugins == *${L3_PLUGINS}* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/'"$L3_PLUGINS"',//g' | sed 's/,'"$L3_PLUGINS"'//g' | sed 's/'"$L3_PLUGINS"'//g'`
                original_service_plugins=`echo $original_service_plugins | sed 's/router,//g' | sed 's/,router//g' | sed 's/router//g'`
                new_service_plugins="router"
            fi
            if [[ $current_service_plugins == *${FWAAS_PLUGINS}* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/'"$FWAAS_PLUGINS"',//g' | sed 's/,'"$FWAAS_PLUGINS"'//g' | sed 's/'"$FWAAS_PLUGINS"'//g'`
            fi
            if [[ $current_service_plugins == *${VPNAAS_PLUGINS}* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/'"$VPNAAS_PLUGINS"',//g' | sed 's/,'"$VPNAAS_PLUGINS"'//g' | sed 's/'"$VPNAAS_PLUGINS"'//g'`
            fi
            if [[ $current_service_plugins == *huawei_ac_l2br* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_l2br,//g' | sed 's/,huawei_ac_l2br//g' | sed 's/huawei_ac_l2br//g'`
            fi
            if [[ $current_service_plugins == *huawei_ac_external_whitelist* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_external_whitelist,//g' | sed 's/,huawei_ac_external_whitelist//g' | sed 's/huawei_ac_external_whitelist//g'`
            fi
            if [[ $current_service_plugins == *huawei_ac_ext* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_ext,//g' | sed 's/,huawei_ac_ext//g' | sed 's/huawei_ac_ext//g'`
            fi
            if [[ $current_service_plugins == *huawei_ac_snat* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_snat,//g' | sed 's/,huawei_ac_snat//g' | sed 's/huawei_ac_snat//g'`
            fi
            if [[ $current_service_plugins == *huawei_ac_vpc_connection* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_vpc_connection,//g' | sed 's/,huawei_ac_vpc_connection//g' | sed 's/huawei_ac_vpc_connection//g'`
            fi
            if [[ $current_service_plugins == *huawei_ac_custom_vpc_connection* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_custom_vpc_connection,//g' | sed 's/,huawei_ac_custom_vpc_connection//g' | sed 's/huawei_ac_custom_vpc_connection//g'`
            fi
            if [[ $current_service_plugins == *huawei_ac_bgp_route* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_bgp_route,//g' | sed 's/,huawei_ac_bgp_route//g' | sed 's/huawei_ac_bgp_route//g'`
            fi
            if [[ $current_service_plugins == *huawei_ac_bgpneighbor* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_bgpneighbor,//g' | sed 's/,huawei_ac_bgpneighbor//g' | sed 's/huawei_ac_bgpneighbor//g'`
            fi
            if [[ $current_service_plugins == *huawei_ac_sync_result* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_sync_result,//g' | sed 's/,huawei_ac_sync_result//g' | sed 's/huawei_ac_sync_result//g'`
            fi
            if [[ $current_service_plugins == *huawei_ac_compare_result* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_compare_result,//g' | sed 's/,huawei_ac_compare_result//g' | sed 's/huawei_ac_compare_result//g'`
            fi
            if [[ $current_service_plugins == *huawei_ac_portforwarding* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_portforwarding,//g' | sed 's/,huawei_ac_portforwarding//g' | sed 's/huawei_ac_portforwarding//g'`
            fi
            if [[ $current_service_plugins == *huawei_ac_flow_mirror* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_flow_mirror,//g' | sed 's/,huawei_ac_flow_mirror//g' | sed 's/huawei_ac_flow_mirror//g'`
            fi
            if [[ $current_service_plugins == *huawei_ac_dry_run_task* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_dry_run_task,//g' | sed 's/,huawei_ac_dry_run_task//g' | sed 's/huawei_ac_dry_run_task//g'`
            fi
            if [[ $current_service_plugins == *huawei_ac_bfd_route* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/huawei_ac_bfd_route,//g' | sed 's/,huawei_ac_bfd_route//g' | sed 's/huawei_ac_bfd_route//g'`
            fi
            if [[ $current_service_plugins == *qos_extension* ]]; then
                current_service_plugins=`echo $current_service_plugins | sed 's/qos_extension,//g' | sed 's/,qos_extension//g' | sed 's/qos_extension//g'`
                original_service_plugins=`echo $original_service_plugins | sed 's/qos_extension,//g' | sed 's/,qos_extension//g' | sed 's/qos_extension//g'`
                new_service_plugins=${new_service_plugins}",qos_extension"
            fi
            if [[ $current_service_plugins != "" ]]; then
                new_service_plugins=${new_service_plugins}","${current_service_plugins}
                new_service_plugins=`echo $new_service_plugins | sed 's/^,//' | sed 's/,$//'`
            fi
            if [[ $original_service_plugins != "" ]]; then
                for plugin in ${original_service_plugins//,/ }; do
                    if [[ $new_service_plugins != *${plugin}* ]]; then
                        new_service_plugins=${new_service_plugins}","${plugin}
                    fi
                done
            fi
            cps template-params-update --service neutron neutron-server --parameter service_plugins=${new_service_plugins// /}
            cps commit

            #mechanism_drivers
            echo -e '2. uninstall mechanism_drivers...'
            sleep 3
            exists_mechanism_drivers=`sed '/^mechanism_drivers =/!d;s/.*=//' /etc/neutron/plugins/ml2/ml2_conf.ini`
            old_mech_drivers=${exists_mechanism_drivers// /}

            if [[ $exists_mechanism_drivers == *huawei_ac_ml2,* ]]
            then
                old_mech_drivers=`echo $old_mech_drivers | sed 's/huawei_ac_ml2,//g' | sed 's/,huawei_ac_ml2//g' | sed 's/huawei_ac_ml2//g'`
                cps template-params-update --service neutron neutron-server --parameter mechanism_drivers=$old_mech_drivers
                cps commit
            fi

            current_extension_drivers=`sed '/^extension_drivers =/!d;s/.*=//' /etc/neutron/plugins/ml2/ml2_conf.ini`
            current_extension_drivers=`echo $current_extension_drivers | sed 's/huawei_ac_binding,//g' | sed 's/,huawei_ac_binding//g' | sed 's/huawei_ac_binding//g'`
            current_extension_drivers=`echo $current_extension_drivers | sed 's/huawei_ac_status_port,//g' | sed 's/,huawei_ac_status_port//g' | sed 's/huawei_ac_status_port//g'`
            current_extension_drivers=`echo $current_extension_drivers | sed 's/huawei_ac_status_firewall_policy,//g' | sed 's/,huawei_ac_status_firewall_policy//g' | sed 's/huawei_ac_status_firewall_policy//g'`
            cps template-params-update --service neutron neutron-server --parameter extension_drivers=${current_extension_drivers// /}
            cps commit

            #notification_drivers
            echo -e '3. uninstall notification_drivers...'
            exists_notification_drivers=`sed '/^notification_drivers =/!d;s/.*=//' /etc/neutron/neutron.conf`
            old_nf_drivers=${exists_notification_drivers// /}

            if [[ $exists_notification_drivers == *huawei_ac_qos_driver* ]]
            then
                old_nf_drivers=`echo $old_nf_drivers | sed 's/huawei_ac_qos_driver//g' | sed 's/^,//' | sed 's/,$//'`
            fi

            cps template-params-update --service neutron neutron-server --parameter notification_drivers=$old_nf_drivers
            cps commit

            #exists_api_extensions_path
            echo -e '4. uninstall api_extensions_path...'

            PYTHON_SITE_PATH=$(python2 -c "import os,neutron; print(os.path.abspath(neutron.__file__))" 2>/dev/null |awk -F '/neutron' '{print $1}')
            PYTHON_SITE_PATH=$(echo $PYTHON_SITE_PATH|grep python || python3 -c "import os,neutron; print(os.path.abspath(neutron.__file__))" 2>/dev/null |awk -F '/neutron' '{print $1}')

            api_ext_vpn=$PYTHON_SITE_PATH/neutron_vpnaas/extensions
            api_ext_fw=$PYTHON_SITE_PATH/neutron_fwaas/extensions
            api_ext_l2br=$PYTHON_SITE_PATH/networking_huawei/drivers/ac/extensions/l2br
            api_ext_sync=$PYTHON_SITE_PATH/networking_huawei/drivers/ac/extensions/sync
            api_ext_exroute_custom=$PYTHON_SITE_PATH/networking_huawei/drivers/ac/extensions/exroute_custom
            api_flowmirror=$PYTHON_SITE_PATH/networking_huawei/drivers/ac/extensions/flowmirror

            exists_api_extensions_path=`sed '/^api_extensions_path =/!d;s/.*=//' /etc/neutron/neutron.conf`
            old_ext_api=${exists_api_extensions_path// /}

            if [[ $exists_api_extensions_path == *:$api_ext_vpn* ]]
            then
                old_ext_api=`echo $old_ext_api | sed -e "s#$api_ext_vpn:##g" | sed -e "s#:$api_ext_vpn##g" | sed -e "s#$api_ext_vpn##g"`
            fi

            if [[ $exists_api_extensions_path == *:$api_ext_fw* ]]
            then
                old_ext_api=`echo $old_ext_api | sed -e "s#$api_ext_fw:##g" | sed -e "s#:$api_ext_fw##g" | sed -e "s#$api_ext_fw##g"`
            fi

            if [[ $exists_api_extensions_path == *:$api_ext_l2br* ]]
            then
                old_ext_api=`echo $old_ext_api | sed -e "s#$api_ext_l2br:##g" | sed -e "s#:$api_ext_l2br##g" | sed -e "s#$api_ext_l2br##g"`
            fi

            if [[ $exists_api_extensions_path == *:$api_ext_sync* ]]
            then
                old_ext_api=`echo $old_ext_api | sed -e "s#$api_ext_sync:##g" | sed -e "s#:$api_ext_sync##g" | sed -e "s#$api_ext_sync##g"`
            fi

            if [[ $exists_api_extensions_path == *:$api_ext_exroute_custom* ]]
            then
                old_ext_api=`echo $old_ext_api | sed -e "s#$api_ext_exroute_custom:##g" | sed -e "s#:$api_ext_exroute_custom##g" | sed -e "s#$api_ext_exroute_custom##g"`
            fi

            if [[ $exists_api_extensions_path == *:$api_flowmirror* ]]
            then
                old_ext_api=`echo $old_ext_api | sed -e "s#$api_flowmirror:##g" | sed -e "s#:$api_flowmirror##g" | sed -e "s#$api_flowmirror##g"`
            fi

            cps template-params-update --service neutron neutron-server --parameter api_extensions_path=$old_ext_api
            cps commit;

            # remove dry-run
            VERSION_FILE="/etc/hostos.version"
            if [[ -e "$VERSION_FILE" ]] && [[ $(grep -c "22.1" $VERSION_FILE) -eq '1' ]]; then
                CUR_PATH=$(dirname $(readlink -f $0))
                off=$(python ${CUR_PATH}/dryrun.py off)
                if [[ $off ]]; then
                    cps template-params-update --service keystone keystone --parameter service_capabilities="$off"
                    cps commit
                    sleep 30
                fi
            fi

            echo -e '+ Uninstall complete!'
            cps template-params-show --service neutron neutron-server
            exit

        elif [ "$choice" == "N" -o "$choice" == "n" ]; then
            exit
        fi
    done
