#!/bin/bash
# Copyright 2021 Huawei Technologies Co. Ltd. All rights reserved.
# example: /bin/bash easy_upload_cert.sh north_server.p12 north_trust.cer xxxx

CUR_PATH=$(dirname $(readlink -f $0))
source $CUR_PATH/common_function.sh

cd $CUR_PATH/certs/

read -s ENC64_PASSWORD
KEY_PASSWORD=`base64 -d <<< $ENC64_PASSWORD`

openssl pkcs12 -in ${1} -out client.cer -nokeys -nomacver << EOF > /dev/null 2>&1
$KEY_PASSWORD
EOF

openssl pkcs12 -in ${1} -nocerts -nomacver -out client_key.pem << EOF > /dev/null 2>&1
$KEY_PASSWORD
$KEY_PASSWORD
$KEY_PASSWORD
EOF

cp ${2} trust.cer
cp ${2} ssl_cacert.pem

ops_version=$(grep ^OPS_version $DRIVER_CONF)

# if FSP after 8.0.0 (include)
if [[ $ops_version =~ "FusionSphere8.0.0" ]] || [[ $ops_version =~ "FusionSphere8.0.3" ]] || [[ $ops_version =~ "FusionSphere21.0" ]]; then
    source_fsp_env
    SSL_CACERT=`cat $CUR_PATH/certs/ssl_cacert.pem`
    TRUST_CERT=`cat $CUR_PATH/certs/trust.cer`
    WEBSOCKET_PUBLIC_KEY=`cat $CUR_PATH/certs/client.cer`
    WEBSOCKET_PRIVATE_KEY=`cat $CUR_PATH/certs/client_key.pem`

    SSL_CACERT_FLAG=`cat $DRIVER_CONF|grep '^https_ca_cert'|awk -F = '{print $1}'`
    TRUST_CERT_FLAG=`cat $DRIVER_CONF|grep '^websocket_ca_cert'|awk -F = '{print $1}'`
    WEBSOCKET_PUBLIC_KEY_FLAG=`cat $DRIVER_CONF|grep '^websocket_public_key'|awk -F = '{print $1}'`
    WEBSOCKET_PRIVATE_KEY_FLAG=`cat $DRIVER_CONF|grep '^websocket_private_key'|awk -F = '{print $1}'`
    WEBSOCKET_KEY_PASS_FLAG=`cat $DRIVER_CONF|grep '^websocket_key_password'|awk -F = '{print $1}'`

    if [[ $SSL_CACERT_FLAG ]]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.https_ca_cert="$SSL_CACERT"
    else
        cps template-ext-params-add --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.https_ca_cert="$SSL_CACERT"
    fi
    if [[ $TRUST_CERT_FLAG ]]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_ca_cert="$TRUST_CERT"
    else
        cps template-ext-params-add --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_ca_cert="$TRUST_CERT"
    fi
    if [[ $WEBSOCKET_PUBLIC_KEY_FLAG ]]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_public_key="$WEBSOCKET_PUBLIC_KEY"
    else
        cps template-ext-params-add --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_public_key="$WEBSOCKET_PUBLIC_KEY"
    fi
    if [[ $WEBSOCKET_PRIVATE_KEY_FLAG ]]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_private_key="$WEBSOCKET_PRIVATE_KEY"
    else
        cps template-ext-params-add --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_private_key="$WEBSOCKET_PRIVATE_KEY"
    fi
    if [[ $WEBSOCKET_KEY_PASS_FLAG ]]; then
        cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_key_password="$KEY_PASSWORD"
    else
        cps template-ext-params-add --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_key_password="$KEY_PASSWORD"
    fi

    cps commit
    exit
fi

# change cert file owner to neutron
if [[ $ops_version =~ "FusionSphere" ]]; then
    chown -R openstack:openstack $CUR_PATH/certs/*
else
    chown -R --reference $NETWORKING_HUAWEI/version.txt $CUR_PATH/certs/*
fi

#change cert file permission
chmod 600 $CUR_PATH/certs/*

# copy cert to plugin code directory
cp -p $CUR_PATH/certs/ssl_cacert.pem $NETWORKING_HUAWEI/drivers/ac/client/
cp -p $CUR_PATH/certs/client.cer $NETWORKING_HUAWEI/drivers/ac/ac_agent/rpc/websocket/
cp -p $CUR_PATH/certs/client_key.pem $NETWORKING_HUAWEI/drivers/ac/ac_agent/rpc/websocket/
cp -p $CUR_PATH/certs/trust.cer $NETWORKING_HUAWEI/drivers/ac/ac_agent/rpc/websocket/

# if FSP between 6.3.1 (include) and 8.0.0 (not include)
if [[ $ops_version =~ "FusionSphere6.3.1" ]] || [[ $ops_version =~ "FusionSphere6.5" ]]; then
    source_fsp_env
    cps template-ext-params-update --service neutron neutron-server --parameter huawei_driver_config.huawei_ac_config.websocket_key_password=$KEY_PASSWORD
    cps commit
    exit
fi

KEY_PASSWORD_ENCRYPT=$(python ${CUR_PATH}/encode.py "$KEY_PASSWORD" "websocket_key_password")
sed -i "s#\websocket_key_password.=.*#websocket_key_password = $KEY_PASSWORD_ENCRYPT#g" $DRIVER_CONF

systemctl restart neutron-server
