#!/usr/bin/env python
# -*- coding:utf-8 -*-
# Copyright 2012 Huawei Technologies Co. Ltd. All rights reserved.
"""encode"""

from __future__ import print_function
import sys
import base64

import encryptor
from networking_huawei.drivers.ac.common.constants import \
    ACCOUNT_SECURE_KEY, KEYSTONE_AUTH_SECURE_KEY, WEBSOCKET_SECURE_KEY
from networking_huawei.drivers.ac.encode_convert import convert_to_bytes


def encode(text, passwd_type):
    """encode"""
    if passwd_type == 'account_passwd':
        passwd_type = ACCOUNT_SECURE_KEY
    elif passwd_type == 'keystone_auth_passwd':
        passwd_type = KEYSTONE_AUTH_SECURE_KEY
    elif passwd_type == 'websocket_key_password':
        passwd_type = WEBSOCKET_SECURE_KEY
    return base64.b64encode(convert_to_bytes(
        encryptor.encrypt_password(text, passwd_type))).decode()


print(encode(sys.argv[1], sys.argv[2]))
